/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.collection.KeyFilteringIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiskMap<T extends Serializable, R>
implements Map<T, R>,
KeyFilteringIterable<T, R>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DiskMap.class);
    private static final String SUBFOLDER_PREFIX = "hudi";
    private final File diskMapPathFile;
    private transient Thread shutdownThread = null;
    protected final String diskMapPath;

    public DiskMap(String basePath, String prefix) throws IOException {
        this.diskMapPath = String.format("%s/%s-%s-%s", basePath, SUBFOLDER_PREFIX, prefix, UUID.randomUUID());
        this.diskMapPathFile = new File(this.diskMapPath);
        FileIOUtils.deleteDirectory((File)this.diskMapPathFile);
        FileIOUtils.mkdir((File)this.diskMapPathFile);
        this.diskMapPathFile.deleteOnExit();
        this.addShutDownHook();
    }

    private void addShutDownHook() {
        DiskMapCleaner.registerForCleanup(this.diskMapPath);
    }

    abstract Stream<R> valueStream();

    abstract long sizeOfFileOnDiskInBytes();

    @Override
    public void close() {
        this.cleanup(false);
    }

    private void cleanup() {
        this.cleanup(true);
    }

    private void cleanup(boolean isTriggeredFromShutdownHook) {
        DiskMapCleaner.cleanupDirectory(this.diskMapPath);
        if (!isTriggeredFromShutdownHook) {
            DiskMapCleaner.deregisterFromCleanup(this.diskMapPath);
        }
    }

    private static class DiskMapCleaner {
        private static final Logger CLEANER_LOG = LoggerFactory.getLogger(DiskMapCleaner.class);
        private static final Set<String> PATHS_TO_CLEAN = Collections.synchronizedSet(new HashSet());
        private static final Thread SHUTDOWN_HOOK = new Thread(() -> {
            Set<String> set = PATHS_TO_CLEAN;
            synchronized (set) {
                PATHS_TO_CLEAN.forEach(DiskMapCleaner::cleanupDirectory);
                PATHS_TO_CLEAN.clear();
            }
        });

        private DiskMapCleaner() {
        }

        public static void registerForCleanup(String directoryPath) {
            PATHS_TO_CLEAN.add(directoryPath);
        }

        public static void deregisterFromCleanup(String directoryPath) {
            PATHS_TO_CLEAN.remove(directoryPath);
        }

        public static void cleanupDirectory(String directoryPath) {
            try {
                FileIOUtils.deleteDirectory((File)new File(directoryPath));
            }
            catch (IOException exception) {
                CLEANER_LOG.warn("Error while deleting the disk map directory=" + directoryPath, (Throwable)exception);
            }
        }

        static {
            Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
        }
    }
}

