/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.InternalSchemaBuilder;
import org.apache.hudi.internal.schema.Types;

public interface TableChange {
    public static ColumnChangeID fromValue(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "add": {
                return ColumnChangeID.ADD;
            }
            case "change": {
                return ColumnChangeID.UPDATE;
            }
            case "delete": {
                return ColumnChangeID.DELETE;
            }
            case "property": {
                return ColumnChangeID.PROPERTY_CHANGE;
            }
            case "replace": {
                return ColumnChangeID.REPLACE;
            }
        }
        throw new IllegalArgumentException("Invalid value of Type.");
    }

    public ColumnChangeID columnChangeId();

    default public boolean withPositionChange() {
        return false;
    }

    public static class ColumnPositionChange {
        private final int srcId;
        private final int dsrId;
        private final ColumnPositionType type;

        static ColumnPositionType fromTypeValue(String value) {
            switch (value.toLowerCase(Locale.ROOT)) {
                case "first": {
                    return ColumnPositionType.FIRST;
                }
                case "before": {
                    return ColumnPositionType.BEFORE;
                }
                case "after": {
                    return ColumnPositionType.AFTER;
                }
                case "no_operation": {
                    return ColumnPositionType.NO_OPERATION;
                }
            }
            throw new IllegalArgumentException(String.format("only support first/before/after but found: %s", value));
        }

        static ColumnPositionChange first(int srcId) {
            return new ColumnPositionChange(srcId, -1, ColumnPositionType.FIRST);
        }

        static ColumnPositionChange before(int srcId, int dsrId) {
            return new ColumnPositionChange(srcId, dsrId, ColumnPositionType.BEFORE);
        }

        static ColumnPositionChange after(int srcId, int dsrId) {
            return new ColumnPositionChange(srcId, dsrId, ColumnPositionType.AFTER);
        }

        static ColumnPositionChange get(int srcId, int dsrId, String type) {
            return ColumnPositionChange.get(srcId, dsrId, ColumnPositionChange.fromTypeValue(type));
        }

        static ColumnPositionChange get(int srcId, int dsrId, ColumnPositionType type) {
            switch (type) {
                case FIRST: {
                    return ColumnPositionChange.first(srcId);
                }
                case BEFORE: {
                    return ColumnPositionChange.before(srcId, dsrId);
                }
                case AFTER: {
                    return ColumnPositionChange.after(srcId, dsrId);
                }
            }
            throw new IllegalArgumentException(String.format("only support first/before/after but found: %s", new Object[]{type}));
        }

        private ColumnPositionChange(int srcId, int dsrId, ColumnPositionType type) {
            this.srcId = srcId;
            this.dsrId = dsrId;
            this.type = type;
        }

        public int getSrcId() {
            return this.srcId;
        }

        public int getDsrId() {
            return this.dsrId;
        }

        public ColumnPositionType type() {
            return this.type;
        }

        public static enum ColumnPositionType {
            FIRST,
            BEFORE,
            AFTER,
            NO_OPERATION;

        }
    }

    public static abstract class BaseColumnChange
    implements TableChange {
        protected final InternalSchema internalSchema;
        protected final Map<Integer, Integer> id2parent;
        protected final Map<Integer, ArrayList<ColumnPositionChange>> positionChangeMap = new HashMap<Integer, ArrayList<ColumnPositionChange>>();
        protected final boolean caseSensitive;

        BaseColumnChange(InternalSchema schema) {
            this(schema, false);
        }

        BaseColumnChange(InternalSchema schema, boolean caseSensitive) {
            this.internalSchema = schema;
            this.id2parent = InternalSchemaBuilder.getBuilder().index2Parents(schema.getRecord());
            this.caseSensitive = caseSensitive;
        }

        public BaseColumnChange addPositionChange(String srcName, String dsrName, ColumnPositionChange.ColumnPositionType orderType) {
            int parentId;
            Integer srcId = this.findIdByFullName(srcName);
            Option dsrIdOpt = dsrName.isEmpty() ? Option.empty() : Option.of((Object)this.findIdByFullName(dsrName));
            Integer srcParentId = this.id2parent.get(srcId);
            Option dsrParentIdOpt = dsrIdOpt.map(this.id2parent::get);
            switch (orderType) {
                case BEFORE: {
                    this.checkColModifyIsLegal(dsrName);
                    break;
                }
                case FIRST: {
                    if (srcId != null && srcId != -1 && srcParentId != null && srcParentId != -1) break;
                    throw new HoodieSchemaException("forbid adjust top-level columns position by using through first syntax");
                }
                case AFTER: {
                    List<String> checkColumns = HoodieRecord.HOODIE_META_COLUMNS.subList(0, HoodieRecord.HOODIE_META_COLUMNS.size() - 2);
                    if (!checkColumns.stream().anyMatch(f -> f.equalsIgnoreCase(dsrName))) break;
                    throw new HoodieSchemaException("forbid adjust the position of ordinary columns between meta columns");
                }
            }
            if (srcParentId != null && dsrParentIdOpt.isPresent() && srcParentId.equals(dsrParentIdOpt.get())) {
                Types.Field parentField = this.internalSchema.findField(srcParentId);
                if (!(parentField.type() instanceof Types.RecordType)) {
                    throw new HoodieSchemaException(String.format("only support reorder fields in struct type, but find: %s", parentField.type()));
                }
                parentId = parentField.fieldId();
            } else if (srcParentId == null && !dsrParentIdOpt.isPresent()) {
                parentId = -1;
            } else if (srcParentId != null && !dsrParentIdOpt.isPresent() && orderType.equals((Object)ColumnPositionChange.ColumnPositionType.FIRST)) {
                parentId = srcParentId;
            } else {
                throw new HoodieSchemaException("cannot order position from different parent");
            }
            ArrayList<ColumnPositionChange> changes = this.positionChangeMap.getOrDefault(parentId, new ArrayList());
            changes.add(ColumnPositionChange.get((int)srcId, (int)((Integer)dsrIdOpt.orElse((Object)-1)), orderType));
            this.positionChangeMap.put(parentId, changes);
            return this;
        }

        public BaseColumnChange addPositionChange(String srcName, String dsrName, String orderType) {
            return this.addPositionChange(srcName, dsrName, ColumnPositionChange.fromTypeValue(orderType));
        }

        protected abstract Integer findIdByFullName(String var1);

        protected void checkColModifyIsLegal(String colNeedToModify) {
            if (HoodieRecord.HOODIE_META_COLUMNS.stream().anyMatch(f -> f.equalsIgnoreCase(colNeedToModify))) {
                throw new IllegalArgumentException(String.format("cannot modify hudi meta col: %s", colNeedToModify));
            }
        }

        @Override
        public boolean withPositionChange() {
            return false;
        }
    }

    public static enum ColumnChangeID {
        ADD,
        UPDATE,
        DELETE,
        PROPERTY_CHANGE,
        REPLACE;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public String getName() {
            return this.name;
        }
    }
}

