/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub.config;

import com.linkedin.common.FabricType;
import com.linkedin.common.urn.DatasetUrn;
import datahub.client.rest.RestEmitter;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.hudi.sync.datahub.config.DataHubEmitterSupplier;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.apache.hudi.sync.datahub.config.HoodieDataHubDatasetIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestDataHubSyncConfig {
    TestDataHubSyncConfig() {
    }

    @Test
    void testGetEmitterFromSupplier() {
        Properties props = new Properties();
        props.setProperty(DataHubSyncConfig.META_SYNC_DATAHUB_EMITTER_SUPPLIER_CLASS.key(), DummySupplier.class.getName());
        DataHubSyncConfig syncConfig = new DataHubSyncConfig(props);
        Assertions.assertNotNull((Object)syncConfig.getRestEmitter());
    }

    @Test
    void testInstantiationWithProps() {
        Properties props = new Properties();
        props.setProperty(DataHubSyncConfig.META_SYNC_DATAHUB_DATASET_IDENTIFIER_CLASS.key(), DummyIdentifier.class.getName());
        DataHubSyncConfig syncConfig = new DataHubSyncConfig(props);
        DatasetUrn datasetUrn = syncConfig.datasetIdentifier.getDatasetUrn();
        Assertions.assertEquals((Object)"foo", (Object)datasetUrn.getPlatformEntity().getPlatformNameEntity());
        Assertions.assertEquals((Object)"project.database.table", (Object)datasetUrn.getDatasetNameEntity());
        Assertions.assertEquals((Object)FabricType.PROD, (Object)datasetUrn.getOriginEntity());
    }

    public static class DummyIdentifier
    extends HoodieDataHubDatasetIdentifier {
        public DummyIdentifier(Properties props) {
            super(props);
        }

        public DatasetUrn getDatasetUrn() {
            try {
                return DatasetUrn.createFromString((String)"urn:li:dataset:(urn:li:dataPlatform:foo,project.database.table,PROD)");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DummySupplier
    implements DataHubEmitterSupplier {
        public RestEmitter get() {
            return RestEmitter.createWithDefaults();
        }
    }
}

