/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import com.linkedin.common.Status;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.dataset.DatasetProperties;
import com.linkedin.schema.ArrayType;
import com.linkedin.schema.BooleanType;
import com.linkedin.schema.BytesType;
import com.linkedin.schema.EnumType;
import com.linkedin.schema.FixedType;
import com.linkedin.schema.MapType;
import com.linkedin.schema.NullType;
import com.linkedin.schema.NumberType;
import com.linkedin.schema.OtherSchema;
import com.linkedin.schema.RecordType;
import com.linkedin.schema.SchemaField;
import com.linkedin.schema.SchemaFieldArray;
import com.linkedin.schema.SchemaFieldDataType;
import com.linkedin.schema.SchemaMetadata;
import com.linkedin.schema.StringType;
import com.linkedin.schema.UnionType;
import datahub.client.Callback;
import datahub.client.rest.RestEmitter;
import datahub.event.MetadataChangeProposalWrapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncException;
import org.apache.hudi.sync.datahub.DatahubResponseLogger;
import org.apache.hudi.sync.datahub.HoodieDataHubSyncException;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.apache.parquet.schema.MessageType;

public class DataHubSyncClient
extends HoodieSyncClient {
    protected final DataHubSyncConfig config;
    private final DatasetUrn datasetUrn;
    private static final Status SOFT_DELETE_FALSE = new Status().setRemoved(false);

    public DataHubSyncClient(DataHubSyncConfig config) {
        super((HoodieSyncConfig)config);
        this.config = config;
        this.datasetUrn = config.datasetIdentifier.getDatasetUrn();
    }

    public Option<String> getLastCommitTimeSynced(String tableName) {
        throw new UnsupportedOperationException("Not supported: `getLastCommitTimeSynced`");
    }

    public void updateLastCommitTimeSynced(String tableName) {
        this.updateTableProperties(tableName, Collections.singletonMap("last_commit_time_sync", ((HoodieInstant)this.getActiveTimeline().lastInstant().get()).getTimestamp()));
    }

    public void updateTableProperties(String tableName, Map<String, String> tableProperties) {
        MetadataChangeProposalWrapper propertiesChangeProposal = MetadataChangeProposalWrapper.builder().entityType("dataset").entityUrn((Urn)this.datasetUrn).upsert().aspect((DataTemplate)new DatasetProperties().setCustomProperties(new StringMap(tableProperties))).build();
        DatahubResponseLogger responseLogger = new DatahubResponseLogger();
        try (RestEmitter emitter = this.config.getRestEmitter();){
            emitter.emit(propertiesChangeProposal, (Callback)responseLogger).get();
        }
        catch (Exception e) {
            throw new HoodieDataHubSyncException("Fail to change properties for Dataset " + this.datasetUrn + ": " + tableProperties, e);
        }
    }

    public void updateTableSchema(String tableName, MessageType schema) {
        try (RestEmitter emitter = this.config.getRestEmitter();){
            DatahubResponseLogger responseLogger = new DatahubResponseLogger();
            MetadataChangeProposalWrapper schemaChange = this.createSchemaMetadataUpdate(tableName);
            emitter.emit(schemaChange, (Callback)responseLogger).get();
            MetadataChangeProposalWrapper softDeleteUndoProposal = this.createUndoSoftDelete();
            emitter.emit(softDeleteUndoProposal, (Callback)responseLogger).get();
        }
        catch (Exception e) {
            throw new HoodieDataHubSyncException("Fail to change schema for Dataset " + this.datasetUrn, e);
        }
    }

    public Map<String, String> getMetastoreSchema(String tableName) {
        throw new UnsupportedOperationException("Not supported: `getMetastoreSchema`");
    }

    public void close() {
    }

    private MetadataChangeProposalWrapper createUndoSoftDelete() {
        MetadataChangeProposalWrapper softDeleteUndoProposal = MetadataChangeProposalWrapper.builder().entityType("dataset").entityUrn((Urn)this.datasetUrn).upsert().aspect((DataTemplate)SOFT_DELETE_FALSE).aspectName("status").build();
        return softDeleteUndoProposal;
    }

    private MetadataChangeProposalWrapper createSchemaMetadataUpdate(String tableName) {
        Schema avroSchema = this.getAvroSchemaWithoutMetadataFields(this.metaClient);
        List fields = avroSchema.getFields().stream().map(f -> new SchemaField().setFieldPath(f.name()).setType(DataHubSyncClient.toSchemaFieldDataType(f.schema().getType())).setDescription(f.doc(), SetMode.IGNORE_NULL).setNativeDataType(f.schema().getType().getName())).collect(Collectors.toList());
        SchemaMetadata.PlatformSchema platformSchema = new SchemaMetadata.PlatformSchema();
        platformSchema.setOtherSchema(new OtherSchema().setRawSchema(avroSchema.toString()));
        return MetadataChangeProposalWrapper.builder().entityType("dataset").entityUrn((Urn)this.datasetUrn).upsert().aspect((DataTemplate)new SchemaMetadata().setSchemaName(tableName).setVersion(0L).setHash("").setPlatform(this.datasetUrn.getPlatformEntity()).setPlatformSchema(platformSchema).setFields(new SchemaFieldArray(fields))).build();
    }

    Schema getAvroSchemaWithoutMetadataFields(HoodieTableMetaClient metaClient) {
        try {
            return new TableSchemaResolver(metaClient).getTableAvroSchema(true);
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read avro schema", (Throwable)e);
        }
    }

    static SchemaFieldDataType toSchemaFieldDataType(Schema.Type type) {
        switch (type) {
            case BOOLEAN: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((BooleanType)new BooleanType()));
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((NumberType)new NumberType()));
            }
            case MAP: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((MapType)new MapType()));
            }
            case ENUM: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((EnumType)new EnumType()));
            }
            case NULL: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((NullType)new NullType()));
            }
            case ARRAY: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((ArrayType)new ArrayType()));
            }
            case BYTES: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((BytesType)new BytesType()));
            }
            case FIXED: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((FixedType)new FixedType()));
            }
            case UNION: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((UnionType)new UnionType()));
            }
            case RECORD: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((RecordType)new RecordType()));
            }
            case STRING: {
                return new SchemaFieldDataType().setType(SchemaFieldDataType.Type.create((StringType)new StringType()));
            }
        }
        throw new AvroTypeException("Unexpected type: " + type.getName());
    }
}

