/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import datahub.client.Callback;
import datahub.client.MetadataWriteResponse;
import datahub.client.rest.RestEmitter;
import datahub.event.MetadataChangeProposalWrapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.DataHubSyncClient;
import org.apache.hudi.sync.datahub.DummyPartitionValueExtractor;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestDataHubSyncClient {
    @Mock
    RestEmitter restEmitterMock;
    @TempDir
    static Path tmpDir;
    private static String TRIP_EXAMPLE_SCHEMA;
    private static Schema avroSchema;
    private static String tableBasePath;

    @BeforeAll
    public static void beforeAll() throws IOException {
        TRIP_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"ts\",\"type\": \"long\"}]}";
        avroSchema = new Schema.Parser().parse(TRIP_EXAMPLE_SCHEMA);
        Properties props = new Properties();
        props.put("hoodie.table.name", "some_table");
        tableBasePath = Paths.get(tmpDir.toString(), "some_table").toString();
        HoodieTableMetaClient.initTableAndGetMetaClient((Configuration)new Configuration(), (String)tableBasePath, (Properties)props);
    }

    @BeforeEach
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterEach
    public void afterEach() {
    }

    @Test
    public void testUpdateTableSchemaInvokesRestEmiiter() throws IOException {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        Mockito.when((Object)this.restEmitterMock.emit((MetadataChangeProposalWrapper)ArgumentMatchers.any(MetadataChangeProposalWrapper.class), (Callback)Mockito.any())).thenReturn(CompletableFuture.completedFuture(MetadataWriteResponse.builder().build()));
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        dhClient.updateTableSchema("some_table", null);
        ((RestEmitter)Mockito.verify((Object)this.restEmitterMock, (VerificationMode)Mockito.times((int)2))).emit((MetadataChangeProposalWrapper)ArgumentMatchers.any(MetadataChangeProposalWrapper.class), (Callback)Mockito.any());
    }

    public class DatahubSyncConfigStub
    extends DataHubSyncConfig {
        private final RestEmitter emitterMock;

        public DatahubSyncConfigStub(Properties props, RestEmitter emitterMock) {
            super(props);
            this.emitterMock = emitterMock;
        }

        public RestEmitter getRestEmitter() {
            return this.emitterMock;
        }
    }

    public class DataHubSyncClientStub
    extends DataHubSyncClient {
        public DataHubSyncClientStub(DataHubSyncConfig config) {
            super(config);
        }

        Schema getAvroSchemaWithoutMetadataFields(HoodieTableMetaClient metaClient) {
            return avroSchema;
        }
    }
}

