/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import com.linkedin.mxe.MetadataChangeProposal;
import datahub.client.Callback;
import datahub.client.MetadataWriteResponse;
import datahub.client.rest.RestEmitter;
import datahub.event.MetadataChangeProposalWrapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.DataHubSyncClient;
import org.apache.hudi.sync.datahub.DummyPartitionValueExtractor;
import org.apache.hudi.sync.datahub.HoodieDataHubSyncException;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestDataHubSyncClient {
    @Mock
    RestEmitter restEmitterMock;
    @TempDir
    static Path tmpDir;
    private static String TRIP_EXAMPLE_SCHEMA;
    private static Schema avroSchema;
    private static String tableBasePath;

    @BeforeAll
    public static void beforeAll() throws IOException {
        TRIP_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"ts\",\"type\": \"long\"}]}";
        avroSchema = new Schema.Parser().parse(TRIP_EXAMPLE_SCHEMA);
        Properties props = new Properties();
        props.put("hoodie.table.name", "some_table");
        tableBasePath = Paths.get(tmpDir.toString(), "some_table").toString();
        HoodieTableMetaClient.newTableBuilder().fromProperties(props).setTableType(HoodieTableType.MERGE_ON_READ.name()).initTable(HadoopFSUtils.getStorageConf((Configuration)new Configuration()), tableBasePath);
    }

    @BeforeEach
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterEach
    public void afterEach() {
    }

    @Test
    public void testUpdateTableSchemaInvokesRestEmitter() throws IOException {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        Mockito.when((Object)this.restEmitterMock.emit((MetadataChangeProposalWrapper)ArgumentMatchers.any(MetadataChangeProposalWrapper.class), (Callback)Mockito.any())).thenReturn(CompletableFuture.completedFuture(MetadataWriteResponse.builder().build()));
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        dhClient.updateTableSchema("some_table", null, null);
        ((RestEmitter)Mockito.verify((Object)this.restEmitterMock, (VerificationMode)Mockito.times((int)9))).emit((MetadataChangeProposalWrapper)ArgumentMatchers.any(MetadataChangeProposalWrapper.class), (Callback)Mockito.any());
    }

    @Test
    public void testUpdateTableProperties() throws Exception {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        Mockito.when((Object)this.restEmitterMock.emit((MetadataChangeProposal)ArgumentMatchers.any(MetadataChangeProposal.class), (Callback)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(MetadataWriteResponse.builder().build()));
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        properties.put("key2", "value2");
        boolean result = dhClient.updateTableProperties("some_table", properties);
        Assertions.assertTrue((boolean)result);
        ((RestEmitter)Mockito.verify((Object)this.restEmitterMock, (VerificationMode)Mockito.times((int)1))).emit((MetadataChangeProposal)ArgumentMatchers.any(MetadataChangeProposal.class), (Callback)ArgumentMatchers.any());
    }

    @Test
    public void testUpdateTablePropertiesFailure() throws Exception {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        props.put(DataHubSyncConfig.META_SYNC_DATAHUB_SYNC_SUPPRESS_EXCEPTIONS.key(), "false");
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(new IOException("Emission failed"));
        Mockito.when((Object)this.restEmitterMock.emit((MetadataChangeProposalWrapper)ArgumentMatchers.any(MetadataChangeProposalWrapper.class), (Callback)ArgumentMatchers.any())).thenReturn(failedFuture);
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key1", "value1");
        Assertions.assertThrows(HoodieDataHubSyncException.class, () -> dhClient.updateTableProperties("some_table", properties));
    }

    @Test
    public void testGetLastCommitTimeSynced() {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> dhClient.getLastCommitTimeSynced("some_table"));
    }

    @Test
    public void testGetMetastoreSchema() {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> dhClient.getMetastoreSchema("some_table"));
    }

    @Test
    public void testUpdateTableSchemaWithEmitterFailure() throws Exception {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        props.put(DataHubSyncConfig.META_SYNC_DATAHUB_SYNC_SUPPRESS_EXCEPTIONS.key(), "false");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new ExecutionException("Emission failed", new IOException()));
        Mockito.when((Object)this.restEmitterMock.emit((MetadataChangeProposalWrapper)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any())).thenReturn(future);
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        Assertions.assertThrows(HoodieDataHubSyncException.class, () -> dhClient.updateTableSchema("some_table", null, null));
    }

    @Test
    public void testUpdateLastCommitTimeSynced() throws Exception {
        Properties props = new Properties();
        props.put(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), DummyPartitionValueExtractor.class.getName());
        props.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), tableBasePath);
        Mockito.when((Object)this.restEmitterMock.emit((MetadataChangeProposal)ArgumentMatchers.any(MetadataChangeProposal.class), (Callback)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(MetadataWriteResponse.builder().build()));
        DatahubSyncConfigStub configStub = new DatahubSyncConfigStub(props, this.restEmitterMock);
        DataHubSyncClientStub dhClient = new DataHubSyncClientStub(configStub);
        dhClient.updateLastCommitTimeSynced("some_table");
        ((RestEmitter)Mockito.verify((Object)this.restEmitterMock, (VerificationMode)Mockito.times((int)2))).emit((MetadataChangeProposal)ArgumentMatchers.any(MetadataChangeProposal.class), (Callback)ArgumentMatchers.any());
    }

    public class DatahubSyncConfigStub
    extends DataHubSyncConfig {
        private final RestEmitter emitterMock;

        public DatahubSyncConfigStub(Properties props, RestEmitter emitterMock) {
            super(props);
            this.emitterMock = emitterMock;
        }

        public RestEmitter getRestEmitter() {
            return this.emitterMock;
        }
    }

    public class DataHubSyncClientStub
    extends DataHubSyncClient {
        public DataHubSyncClientStub(DataHubSyncConfig config) {
            super(config, (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class));
        }

        Schema getAvroSchemaWithoutMetadataFields(HoodieTableMetaClient metaClient) {
            return avroSchema;
        }

        protected Option<String> getLastCommitTime() {
            return Option.of((Object)"1000");
        }

        protected Option<String> getLastCommitCompletionTime() {
            return Option.of((Object)"1000");
        }
    }
}

