/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.hudi.sync.common.util.SyncUtilHelpers;
import org.apache.hudi.sync.datahub.DataHubSyncTool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestDataHubSyncTool
extends HoodieCommonTestHarness {
    TestDataHubSyncTool() {
    }

    @Test
    void validateInitThroughSyncTool() throws Exception {
        String path = "file:///tmp/path";
        Configuration configuration = new Configuration();
        TypedProperties typedProperties = new TypedProperties();
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        HoodieSyncTool syncTool = SyncUtilHelpers.instantiateMetaSyncTool((String)DataHubSyncTool.class.getName(), (TypedProperties)typedProperties, (Configuration)configuration, (FileSystem)new Path(path).getFileSystem(configuration), (String)path, (String)"PARQUET", (Option)Option.of((Object)mockMetaClient));
        Assertions.assertTrue((boolean)(syncTool instanceof DataHubSyncTool));
        syncTool.close();
    }

    @Test
    void validatePropsConstructor() throws Exception {
        this.initMetaClient();
        TypedProperties typedProperties = new TypedProperties();
        typedProperties.setProperty("hoodie.datasource.meta.sync.base.path", this.metaClient.getBasePath().toString());
        Assertions.assertDoesNotThrow(() -> {
            DataHubSyncTool syncTool = new DataHubSyncTool((Properties)typedProperties);
            syncTool.close();
        });
    }
}

