/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.DataHubTableProperties;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestDataHubTableProperties {
    TestDataHubTableProperties() {
    }

    @Test
    void testGetTableProperties() {
        String path = "file:///tmp/path";
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("hudi.table.type", "MERGE_ON_READ");
        expected.put("hudi.table.version", "SIX");
        expected.put("hudi.base.path", path);
        expected.put("spark.path", path);
        expected.put("serdeClass", ParquetHiveSerDe.class.getName());
        expected.put("spark.sql.sources.schema.numParts", "1");
        expected.put("spark.sql.sources.provider", "hudi");
        expected.put("spark.hoodie.query.as.ro.table", "false");
        expected.put("spark.sql.sources.schema.part.0", "{\"type\":\"struct\",\"fields\":[{\"name\":\"int_field\",\"type\":\"integer\",\"nullable\":false,\"metadata\":{}}]}");
        expected.put("inputFormat", HoodieParquetInputFormat.class.getName());
        expected.put("outputFormat", MapredParquetOutputFormat.class.getName());
        TypedProperties properties = new TypedProperties();
        properties.put((Object)HoodieSyncConfig.META_SYNC_BASE_PATH.key(), (Object)path);
        DataHubSyncConfig config = new DataHubSyncConfig((Properties)properties);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)metaClient.getTableType().name()).thenReturn((Object)HoodieTableType.MERGE_ON_READ.name());
        Mockito.when((Object)metaClient.getTableConfig().getTableVersion()).thenReturn((Object)HoodieTableVersion.SIX);
        MessageType messageType = new MessageType("record", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "int_field")});
        DataHubTableProperties.HoodieTableMetadata tableMetadata = new DataHubTableProperties.HoodieTableMetadata(metaClient, messageType);
        Map actual = DataHubTableProperties.getTableProperties((DataHubSyncConfig)config, (DataHubTableProperties.HoodieTableMetadata)tableMetadata);
        Assertions.assertEquals(expected, (Object)actual);
    }
}

