/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.datahub.config;

import com.linkedin.common.FabricType;
import com.linkedin.common.urn.DatasetUrn;
import com.linkedin.common.urn.Urn;
import java.util.Properties;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.datahub.config.DataHubSyncConfig;
import org.apache.hudi.sync.datahub.config.HoodieDataHubDatasetIdentifier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class TestHoodieDataHubDatasetIdentifier {
    private Properties props;

    TestHoodieDataHubDatasetIdentifier() {
    }

    @BeforeEach
    void setUp() {
        this.props = new Properties();
    }

    @Test
    @DisplayName(value="Test constructor with default values")
    void testConstructorWithDefaultValues() {
        this.props.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "test_db");
        this.props.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), "test_table");
        HoodieDataHubDatasetIdentifier identifier = new HoodieDataHubDatasetIdentifier(this.props);
        DatasetUrn datasetUrn = identifier.getDatasetUrn();
        Assertions.assertNotNull((Object)datasetUrn);
        Assertions.assertEquals((Object)"hudi", (Object)datasetUrn.getPlatformEntity().getId());
        Assertions.assertEquals((Object)"test_db.test_table", (Object)datasetUrn.getDatasetNameEntity());
        Assertions.assertEquals((Object)HoodieDataHubDatasetIdentifier.DEFAULT_DATAHUB_ENV, (Object)datasetUrn.getOriginEntity());
    }

    @Test
    @DisplayName(value="Test constructor with custom values")
    void testConstructorWithCustomValues() {
        this.props.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "custom_db");
        this.props.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), "custom_table");
        this.props.setProperty(DataHubSyncConfig.META_SYNC_DATAHUB_DATAPLATFORM_NAME.key(), "custom_platform");
        this.props.setProperty(DataHubSyncConfig.META_SYNC_DATAHUB_DATASET_ENV.key(), "PROD");
        HoodieDataHubDatasetIdentifier identifier = new HoodieDataHubDatasetIdentifier(this.props);
        DatasetUrn datasetUrn = identifier.getDatasetUrn();
        Assertions.assertNotNull((Object)datasetUrn);
        Assertions.assertEquals((Object)"custom_platform", (Object)datasetUrn.getPlatformEntity().getId());
        Assertions.assertEquals((Object)"custom_db.custom_table", (Object)datasetUrn.getDatasetNameEntity());
        Assertions.assertEquals((Object)FabricType.PROD, (Object)datasetUrn.getOriginEntity());
    }

    @Test
    @DisplayName(value="Test getDatabaseUrn")
    void testGetDatabaseUrn() {
        this.props.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "test_db");
        this.props.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), "test_table");
        this.props.setProperty(DataHubSyncConfig.META_SYNC_DATAHUB_DATASET_ENV.key(), "PROD");
        HoodieDataHubDatasetIdentifier identifier = new HoodieDataHubDatasetIdentifier(this.props);
        Urn databaseUrn = identifier.getDatabaseUrn();
        Assertions.assertNotNull((Object)databaseUrn);
        Assertions.assertFalse((boolean)databaseUrn.toString().contains("test_db"));
        Assertions.assertFalse((boolean)databaseUrn.toString().contains("PROD"));
        Assertions.assertTrue((boolean)databaseUrn.toString().startsWith("urn:li:container:"));
    }

    @Test
    @DisplayName(value="Test getTableName")
    void testGetTableName() {
        String tableName = "test_table";
        this.props.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "test_db");
        this.props.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), tableName);
        HoodieDataHubDatasetIdentifier identifier = new HoodieDataHubDatasetIdentifier(this.props);
        Assertions.assertEquals((Object)tableName, (Object)identifier.getTableName());
    }

    @Test
    @DisplayName(value="Test constructor with missing required properties")
    void testConstructorWithMissingProperties() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieDataHubDatasetIdentifier(this.props));
    }

    @Test
    @DisplayName(value="Test constructor with invalid environment")
    void testConstructorWithInvalidEnvironment() {
        this.props.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), "test_db");
        this.props.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), "test_table");
        this.props.setProperty(DataHubSyncConfig.META_SYNC_DATAHUB_DATASET_ENV.key(), "INVALID_ENV");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HoodieDataHubDatasetIdentifier(this.props));
    }
}

