/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.quickstart;

import java.io.File;
import java.util.List;
import org.apache.flink.test.util.AbstractTestBase;
import org.apache.flink.types.Row;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.examples.quickstart.HoodieFlinkQuickstart;
import org.apache.hudi.examples.quickstart.TestQuickstartData;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestHoodieFlinkQuickstart
extends AbstractTestBase {
    private final HoodieFlinkQuickstart flinkQuickstart = HoodieFlinkQuickstart.instance();
    @TempDir
    File tempFile;

    @BeforeEach
    void beforeEach() {
        this.flinkQuickstart.initEnv();
    }

    @ParameterizedTest
    @EnumSource(value=HoodieTableType.class)
    void testHoodieFlinkQuickstart(HoodieTableType tableType) throws Exception {
        this.flinkQuickstart.createFileSource();
        this.flinkQuickstart.createHudiTable(this.tempFile.getAbsolutePath(), "t1", tableType);
        List rows = this.flinkQuickstart.insertData();
        TestQuickstartData.assertRowsEquals((List<Row>)rows, TestQuickstartData.DATA_SET_SOURCE_INSERT_LATEST_COMMIT);
        List rows1 = this.flinkQuickstart.queryData();
        TestQuickstartData.assertRowsEquals((List<Row>)rows1, TestQuickstartData.DATA_SET_SOURCE_INSERT_LATEST_COMMIT);
        List rows2 = this.flinkQuickstart.updateData();
        TestQuickstartData.assertRowsEquals((List<Row>)rows2, TestQuickstartData.DATA_SET_SOURCE_INSERT_LATEST_COMMIT);
    }
}

