/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.quickstart;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.examples.quickstart.utils.QuickstartConfigurations;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.parquet.Strings;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;

public class TestQuickstartData {
    public static List<RowData> DATA_SET_INSERT_DUPLICATES = new ArrayList<RowData>();
    public static List<RowData> DATA_SET_INSERT_SAME_KEY;
    public static List<RowData> DATA_SET_SOURCE_INSERT_LATEST_COMMIT;
    public static List<RowData> DATA_SET_DISORDER_UPDATE_DELETE;

    public static List<RowData> dataSetInsert(int ... ids) {
        ArrayList<RowData> inserts = new ArrayList<RowData>();
        Arrays.stream(ids).forEach(i -> inserts.add((RowData)TestQuickstartData.insertRow(StringData.fromString((String)("id" + i)), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)i), StringData.fromString((String)"par1"))));
        return inserts;
    }

    private static Integer toIdSafely(Object id) {
        if (id == null) {
            return -1;
        }
        String idStr = id.toString();
        if (idStr.startsWith("id")) {
            return Integer.parseInt(idStr.substring(2));
        }
        return -1;
    }

    public static String rowDataToString(List<RowData> rows) {
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)QuickstartConfigurations.ROW_DATA_TYPE);
        return rows.stream().sorted(Comparator.comparing(o -> TestQuickstartData.toIdSafely(o.getString(0)))).map(row -> converter.toExternal(row).toString()).collect(Collectors.toList()).toString();
    }

    private static String toStringSafely(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static void assertRowsEquals(List<Row> rows, String expected) {
        TestQuickstartData.assertRowsEquals(rows, expected, false);
    }

    public static void assertRowsEquals(List<Row> rows, String expected, boolean withChangeFlag) {
        String rowsString = rows.stream().sorted(Comparator.comparing(o -> TestQuickstartData.toStringSafely(o.getField(0)))).map(row -> {
            String rowStr = row.toString();
            if (withChangeFlag) {
                return row.getKind().shortString() + "(" + rowStr + ")";
            }
            return rowStr;
        }).collect(Collectors.toList()).toString();
        MatcherAssert.assertThat((Object)rowsString, (Matcher)CoreMatchers.is((Object)expected));
    }

    public static void assertRowsEquals(List<Row> rows, String expected, int orderingPos) {
        String rowsString = rows.stream().sorted(Comparator.comparing(o -> TestQuickstartData.toStringSafely(o.getField(orderingPos)))).collect(Collectors.toList()).toString();
        MatcherAssert.assertThat((Object)rowsString, (Matcher)CoreMatchers.is((Object)expected));
    }

    public static void assertRowsEquals(List<Row> rows, List<RowData> expected) {
        String rowsString = rows.stream().sorted(Comparator.comparing(o -> TestQuickstartData.toIdSafely(o.getField(0)))).collect(Collectors.toList()).toString();
        MatcherAssert.assertThat((Object)rowsString, (Matcher)CoreMatchers.is((Object)TestQuickstartData.rowDataToString(expected)));
    }

    public static void assertRowDataEquals(List<RowData> rows, String expected) {
        String rowsString = TestQuickstartData.rowDataToString(rows);
        MatcherAssert.assertThat((Object)rowsString, (Matcher)CoreMatchers.is((Object)expected));
    }

    public static void assertRowDataEquals(List<RowData> rows, List<RowData> expected) {
        String rowsString = TestQuickstartData.rowDataToString(rows);
        MatcherAssert.assertThat((Object)rowsString, (Matcher)CoreMatchers.is((Object)TestQuickstartData.rowDataToString(expected)));
    }

    public static void checkWrittenData(File baseFile, Map<String, String> expected) throws IOException {
        TestQuickstartData.checkWrittenData(baseFile, expected, 4);
    }

    public static void checkWrittenData(File baseFile, Map<String, String> expected, int partitions) throws IOException {
        assert (baseFile.isDirectory());
        FileFilter filter = file -> !file.getName().startsWith(".");
        File[] partitionDirs = baseFile.listFiles(filter);
        Assertions.assertNotNull((Object)partitionDirs);
        MatcherAssert.assertThat((Object)partitionDirs.length, (Matcher)CoreMatchers.is((Object)partitions));
        for (File partitionDir : partitionDirs) {
            File[] dataFiles = partitionDir.listFiles(filter);
            Assertions.assertNotNull((Object)dataFiles);
            File latestDataFile = Arrays.stream(dataFiles).max(Comparator.comparing(f -> FSUtils.getCommitTime((String)f.getName()))).orElse(dataFiles[0]);
            ParquetReader reader = AvroParquetReader.builder((Path)new Path(latestDataFile.getAbsolutePath())).build();
            ArrayList<String> readBuffer = new ArrayList<String>();
            GenericRecord nextRecord = (GenericRecord)reader.read();
            while (nextRecord != null) {
                readBuffer.add(TestQuickstartData.filterOutVariables(nextRecord));
                nextRecord = (GenericRecord)reader.read();
            }
            readBuffer.sort(Comparator.naturalOrder());
            MatcherAssert.assertThat((Object)((Object)readBuffer).toString(), (Matcher)CoreMatchers.is((Object)expected.get(partitionDir.getName())));
        }
    }

    public static void checkWrittenDataMOR(HoodieStorage storage, String latestInstant, File baseFile, Map<String, String> expected, int partitions, Schema schema) {
        assert (baseFile.isDirectory()) : "Base path should be a directory";
        FileFilter partitionFilter = file -> !file.getName().startsWith(".");
        File[] partitionDirs = baseFile.listFiles(partitionFilter);
        Assertions.assertNotNull((Object)partitionDirs);
        MatcherAssert.assertThat((Object)partitionDirs.length, (Matcher)CoreMatchers.is((Object)partitions));
        for (File partitionDir : partitionDirs) {
            File[] dataFiles = partitionDir.listFiles(file -> file.getName().contains(".log.") && !file.getName().startsWith(".."));
            Assertions.assertNotNull((Object)dataFiles);
            HoodieMergedLogRecordScanner scanner = TestQuickstartData.getScanner(storage, baseFile.getPath(), Arrays.stream(dataFiles).map(File::getAbsolutePath).sorted(Comparator.naturalOrder()).collect(Collectors.toList()), schema, latestInstant);
            List readBuffer = scanner.getRecords().values().stream().map(hoodieRecord -> {
                try {
                    GenericRecord record = (GenericRecord)((HoodieAvroRecord)hoodieRecord).getData().getInsertValue(schema, new Properties()).orElse(null);
                    return record == null ? (String)null : TestQuickstartData.filterOutVariables(record);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).filter(Objects::nonNull).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
            MatcherAssert.assertThat((Object)readBuffer.toString(), (Matcher)CoreMatchers.is((Object)expected.get(partitionDir.getName())));
        }
    }

    private static HoodieMergedLogRecordScanner getScanner(HoodieStorage storage, String basePath, List<String> logPaths, Schema readSchema, String instant) {
        return HoodieMergedLogRecordScanner.newBuilder().withStorage(storage).withBasePath(basePath).withLogFilePaths(logPaths).withReaderSchema(readSchema).withLatestInstantTime(instant).withReverseReader(false).withBufferSize(0x1000000).withMaxMemorySizeInBytes(Long.valueOf(0x100000L)).withSpillableMapBasePath("/tmp/").withDiskMapType((ExternalSpillableMap.DiskMapType)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue()).withBitCaskDiskMapCompressionEnabled(((Boolean)HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue()).booleanValue()).build();
    }

    private static String filterOutVariables(GenericRecord genericRecord) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(genericRecord.get("_hoodie_record_key").toString());
        fields.add(genericRecord.get("_hoodie_partition_path").toString());
        fields.add(genericRecord.get("uuid").toString());
        fields.add(genericRecord.get("name").toString());
        fields.add(genericRecord.get("age").toString());
        fields.add(genericRecord.get("ts").toString());
        fields.add(genericRecord.get("partition").toString());
        return Strings.join(fields, (String)",");
    }

    public static BinaryRowData insertRow(Object ... fields) {
        return TestQuickstartData.insertRow(QuickstartConfigurations.ROW_TYPE, fields);
    }

    public static BinaryRowData insertRow(RowType rowType, Object ... fields) {
        LogicalType[] types = (LogicalType[])rowType.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        TestCase.assertEquals((String)"Filed count inconsistent with type information", (int)fields.length, (int)types.length);
        BinaryRowData row = new BinaryRowData(fields.length);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        for (int i = 0; i < fields.length; ++i) {
            Object field = fields[i];
            if (field == null) {
                writer.setNullAt(i);
                continue;
            }
            BinaryWriter.write((BinaryWriter)writer, (int)i, (Object)field, (LogicalType)types[i], (TypeSerializer)InternalSerializers.create((LogicalType)types[i]));
        }
        writer.complete();
        return row;
    }

    private static BinaryRowData deleteRow(Object ... fields) {
        BinaryRowData rowData = TestQuickstartData.insertRow(fields);
        rowData.setRowKind(RowKind.DELETE);
        return rowData;
    }

    private static BinaryRowData updateBeforeRow(Object ... fields) {
        BinaryRowData rowData = TestQuickstartData.insertRow(fields);
        rowData.setRowKind(RowKind.UPDATE_BEFORE);
        return rowData;
    }

    private static BinaryRowData updateAfterRow(Object ... fields) {
        BinaryRowData rowData = TestQuickstartData.insertRow(fields);
        rowData.setRowKind(RowKind.UPDATE_AFTER);
        return rowData;
    }

    static {
        IntStream.range(0, 5).forEach(i -> DATA_SET_INSERT_DUPLICATES.add((RowData)TestQuickstartData.insertRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)"par1"))));
        DATA_SET_INSERT_SAME_KEY = new ArrayList<RowData>();
        IntStream.range(0, 5).forEach(i -> DATA_SET_INSERT_SAME_KEY.add((RowData)TestQuickstartData.insertRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)i), StringData.fromString((String)"par1"))));
        DATA_SET_SOURCE_INSERT_LATEST_COMMIT = Arrays.asList(TestQuickstartData.insertRow(StringData.fromString((String)"id5"), StringData.fromString((String)"Sophia"), 18, TimestampData.fromEpochMillis((long)5000L), StringData.fromString((String)"par3")), TestQuickstartData.insertRow(StringData.fromString((String)"id6"), StringData.fromString((String)"Emma"), 20, TimestampData.fromEpochMillis((long)6000L), StringData.fromString((String)"par3")), TestQuickstartData.insertRow(StringData.fromString((String)"id7"), StringData.fromString((String)"Bob"), 44, TimestampData.fromEpochMillis((long)7000L), StringData.fromString((String)"par4")), TestQuickstartData.insertRow(StringData.fromString((String)"id8"), StringData.fromString((String)"Han"), 56, TimestampData.fromEpochMillis((long)8000L), StringData.fromString((String)"par4")));
        DATA_SET_DISORDER_UPDATE_DELETE = Arrays.asList(TestQuickstartData.updateAfterRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 21, TimestampData.fromEpochMillis((long)3L), StringData.fromString((String)"par1")), TestQuickstartData.updateAfterRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 20, TimestampData.fromEpochMillis((long)2L), StringData.fromString((String)"par1")), TestQuickstartData.updateBeforeRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 23, TimestampData.fromEpochMillis((long)1L), StringData.fromString((String)"par1")), TestQuickstartData.updateBeforeRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 20, TimestampData.fromEpochMillis((long)2L), StringData.fromString((String)"par1")), TestQuickstartData.updateAfterRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 22, TimestampData.fromEpochMillis((long)4L), StringData.fromString((String)"par1")), TestQuickstartData.updateBeforeRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 21, TimestampData.fromEpochMillis((long)3L), StringData.fromString((String)"par1")), TestQuickstartData.deleteRow(StringData.fromString((String)"id1"), StringData.fromString((String)"Danny"), 22, TimestampData.fromEpochMillis((long)2L), StringData.fromString((String)"par1")));
    }
}

