/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.quickstart.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.examples.quickstart.utils.SchemaBuilder;
import org.apache.hudi.streamer.FlinkStreamerConfig;

public class QuickstartConfigurations {
    public static final DataType ROW_DATA_TYPE = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"partition", (DataType)DataTypes.VARCHAR((int)10))}).notNull();
    public static final RowType ROW_TYPE = (RowType)ROW_DATA_TYPE.getLogicalType();
    public static final ResolvedSchema TABLE_SCHEMA = SchemaBuilder.instance().fields(ROW_TYPE.getFieldNames(), ROW_DATA_TYPE.getChildren()).build();
    private static final List<String> FIELDS = ROW_TYPE.getFields().stream().map(RowType.RowField::asSummaryString).collect(Collectors.toList());
    public static final DataType ROW_DATA_TYPE_WIDER = (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"uuid", (DataType)DataTypes.VARCHAR((int)20)), DataTypes.FIELD((String)"name", (DataType)DataTypes.VARCHAR((int)10)), DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"salary", (DataType)DataTypes.DOUBLE()), DataTypes.FIELD((String)"ts", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"partition", (DataType)DataTypes.VARCHAR((int)10))}).notNull();
    public static final RowType ROW_TYPE_WIDER = (RowType)ROW_DATA_TYPE_WIDER.getLogicalType();
    public static final RowDataSerializer SERIALIZER = new RowDataSerializer(ROW_TYPE);

    private QuickstartConfigurations() {
    }

    public static String getCreateHoodieTableDDL(String tableName, Map<String, String> options) {
        return QuickstartConfigurations.getCreateHoodieTableDDL(tableName, options, true, "partition");
    }

    public static String getCreateHoodieTableDDL(String tableName, Map<String, String> options, boolean havePartition, String partitionField) {
        return QuickstartConfigurations.getCreateHoodieTableDDL(tableName, FIELDS, options, havePartition, "uuid", partitionField);
    }

    public static String getCreateHoodieTableDDL(String tableName, List<String> fields, Map<String, String> options, boolean havePartition, String pkField, String partitionField) {
        StringBuilder builder = new StringBuilder();
        builder.append("create table ").append(tableName).append("(\n");
        for (String field : fields) {
            builder.append("  ").append(field).append(",\n");
        }
        builder.append("  PRIMARY KEY(").append(pkField).append(") NOT ENFORCED\n").append(")\n");
        if (havePartition) {
            builder.append("PARTITIONED BY (`").append(partitionField).append("`)\n");
        }
        String connector = options.computeIfAbsent("connector", k -> "hudi");
        builder.append("with (\n  'connector' = '").append(connector).append("'");
        options.forEach((k, v) -> builder.append(",\n").append("  '").append((String)k).append("' = '").append((String)v).append("'"));
        builder.append("\n)");
        return builder.toString();
    }

    public static String getCreateHudiCatalogDDL(String catalogName, String catalogPath) {
        return "create catalog " + catalogName + " with (\n  'type' = 'hudi',\n  'catalog.path' = '" + catalogPath + "'\n)";
    }

    public static String getFileSourceDDL(String tableName) {
        return QuickstartConfigurations.getFileSourceDDL(tableName, "source-file.json");
    }

    public static String getFileSourceDDL(String tableName, int checkpoints) {
        return QuickstartConfigurations.getFileSourceDDL(tableName, "source-file.json", checkpoints);
    }

    public static String getFileSourceDDL(String tableName, String fileName) {
        return QuickstartConfigurations.getFileSourceDDL(tableName, fileName, 2);
    }

    public static String getFileSourceDDL(String tableName, String fileName, int checkpoints) {
        String sourcePath = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(fileName)).toString();
        return "create table " + tableName + "(\n  uuid varchar(20),\n  name varchar(10),\n  age int,\n  ts timestamp(3),\n  `partition` varchar(20)\n) with (\n  'connector' = '" + "continuous-file-source" + "',\n  'path' = '" + sourcePath + "',\n  'checkpoints' = '" + checkpoints + "'\n)";
    }

    public static String getCollectSinkDDL(String tableName) {
        return "create table " + tableName + "(\n  uuid varchar(20),\n  name varchar(10),\n  age int,\n  ts timestamp(3),\n  `partition` varchar(20)\n) with (\n  'connector' = '" + "collect" + "')";
    }

    public static String getCollectSinkDDL(String tableName, ResolvedSchema tableSchema) {
        StringBuilder builder = new StringBuilder("create table " + tableName + "(\n");
        List columns = tableSchema.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            builder.append("  `").append(column.getName()).append("` ").append(column.getDataType());
            if (i != columns.size() - 1) {
                builder.append(",");
            }
            builder.append("\n");
        }
        String withProps = ") with (\n  'connector' = 'collect'\n)";
        builder.append(") with (\n  'connector' = 'collect'\n)");
        return builder.toString();
    }

    public static String getCsvSourceDDL(String tableName, String fileName) {
        String sourcePath = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(fileName)).toString();
        return "create table " + tableName + "(\n  uuid varchar(20),\n  name varchar(10),\n  age int,\n  ts timestamp(3),\n  `partition` varchar(20)\n) with (\n  'connector' = 'filesystem',\n  'path' = '" + sourcePath + "',\n  'format' = 'csv'\n)";
    }

    public static Configuration getDefaultConf(String tablePath) {
        Configuration conf = new Configuration();
        conf.setString(FlinkOptions.PATH, tablePath);
        conf.setString(FlinkOptions.SOURCE_AVRO_SCHEMA_PATH, Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("test_read_schema.avsc")).toString());
        conf.setString(FlinkOptions.TABLE_NAME, "TestHoodieTable");
        conf.setString(FlinkOptions.PARTITION_PATH_FIELD, "partition");
        return conf;
    }

    public static FlinkStreamerConfig getDefaultStreamerConf(String tablePath) {
        FlinkStreamerConfig streamerConf = new FlinkStreamerConfig();
        streamerConf.targetBasePath = tablePath;
        streamerConf.sourceAvroSchemaPath = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("test_read_schema.avsc")).toString();
        streamerConf.targetTableName = "TestHoodieTable";
        streamerConf.partitionPathField = "partition";
        streamerConf.tableType = "COPY_ON_WRITE";
        streamerConf.checkpointInterval = 4000L;
        return streamerConf;
    }

    public static Sql sql(String tableName) {
        return new Sql(tableName);
    }

    public static Catalog catalog(String catalogName) {
        return new Catalog(catalogName);
    }

    public static class Catalog {
        private final String catalogName;
        private String catalogPath = ".";

        public Catalog(String catalogName) {
            this.catalogName = catalogName;
        }

        public Catalog catalogPath(String catalogPath) {
            this.catalogPath = catalogPath;
            return this;
        }

        public String end() {
            return QuickstartConfigurations.getCreateHudiCatalogDDL(this.catalogName, this.catalogPath);
        }
    }

    public static class Sql {
        private final Map<String, String> options;
        private final String tableName;
        private List<String> fields = new ArrayList<String>();
        private boolean withPartition = true;
        private String pkField = "uuid";
        private String partitionField = "partition";

        public Sql(String tableName) {
            this.options = new HashMap<String, String>();
            this.tableName = tableName;
        }

        public Sql option(ConfigOption<?> option, Object val) {
            this.options.put(option.key(), val.toString());
            return this;
        }

        public Sql option(String key, Object val) {
            this.options.put(key, val.toString());
            return this;
        }

        public Sql options(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public Sql noPartition() {
            this.withPartition = false;
            return this;
        }

        public Sql pkField(String pkField) {
            this.pkField = pkField;
            return this;
        }

        public Sql partitionField(String partitionField) {
            this.partitionField = partitionField;
            return this;
        }

        public Sql field(String fieldSchema) {
            this.fields.add(fieldSchema);
            return this;
        }

        public String end() {
            if (this.fields.size() == 0) {
                this.fields = FIELDS;
            }
            return QuickstartConfigurations.getCreateHoodieTableDDL(this.tableName, this.fields, this.options, this.withPartition, this.pkField, this.partitionField);
        }
    }
}

