/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.java;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.examples.common.HoodieExampleDataGenerator;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieJavaWriteClientExample {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieJavaWriteClientExample.class);
    private static String tableType = HoodieTableType.COPY_ON_WRITE.name();
    private static final String MOR_STR = "mor";

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: HoodieJavaWriteClientExample <tablePath> <tableName> <tableType: [cow|mor]>");
            System.exit(1);
        }
        String tablePath = args[0];
        String tableName = args[1];
        String tableTypeStr = args[2];
        if (tableTypeStr != null && tableTypeStr.equals(MOR_STR)) {
            tableType = HoodieTableType.MERGE_ON_READ.name();
        }
        LOG.info("Start JavaWriteClient example with tablePath: {}, tableName: {}, tableType: {}", new Object[]{tablePath, tableName, tableType});
        HoodieExampleDataGenerator dataGen = new HoodieExampleDataGenerator();
        StorageConfiguration storageConf = HadoopFSUtils.getStorageConf((Configuration)new Configuration());
        Path path = new Path(tablePath);
        FileSystem fs = HadoopFSUtils.getFs((String)tablePath, (StorageConfiguration)storageConf);
        if (!fs.exists(path)) {
            HoodieTableMetaClient.newTableBuilder().setTableType(tableType).setTableName(tableName).setPayloadClassName(HoodieAvroPayload.class.getName()).initTable(storageConf, tablePath);
        }
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(tablePath).withSchema(HoodieExampleDataGenerator.TRIP_EXAMPLE_SCHEMA).withParallelism(2, 2).withDeleteParallelism(2).forTable(tableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(20, 30).build()).build();
        try (HoodieJavaWriteClient client = new HoodieJavaWriteClient((HoodieEngineContext)new HoodieJavaEngineContext(storageConf), cfg);){
            String newCommitTime = client.startCommit();
            LOG.info("Starting commit {}", (Object)newCommitTime);
            List records = dataGen.generateInserts(newCommitTime, Integer.valueOf(10));
            ArrayList recordsSoFar = new ArrayList(records);
            List writeRecords = recordsSoFar.stream().map(HoodieAvroRecord::new).collect(Collectors.toList());
            client.insert(writeRecords, newCommitTime);
            newCommitTime = client.startCommit();
            LOG.info("Starting commit {}", (Object)newCommitTime);
            List toBeUpdated = dataGen.generateUpdates(newCommitTime, Integer.valueOf(2));
            records.addAll(toBeUpdated);
            recordsSoFar.addAll(toBeUpdated);
            writeRecords = recordsSoFar.stream().map(HoodieAvroRecord::new).collect(Collectors.toList());
            client.upsert(writeRecords, newCommitTime);
            newCommitTime = client.startCommit();
            LOG.info("Starting commit {}", (Object)newCommitTime);
            int numToDelete = recordsSoFar.size() / 2;
            List toBeDeleted = recordsSoFar.stream().map(HoodieRecord::getKey).limit(numToDelete).collect(Collectors.toList());
            client.delete(toBeDeleted, newCommitTime);
        }
    }
}

