/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.quickstart;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hudi.client.SparkRDDReadClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.examples.quickstart.HoodieSparkQuickstart;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.hudi.testutils.providers.SparkProvider;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.Utils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHoodieSparkQuickstart
implements SparkProvider {
    protected static HoodieSparkEngineContext context;
    private static SparkSession spark;
    private static SQLContext sqlContext;
    private static JavaSparkContext jsc;
    protected boolean initialized = false;
    @TempDir
    protected Path tempDir;

    public SparkSession spark() {
        return spark;
    }

    public SparkConf conf() {
        return this.conf(SparkClientFunctionalTestHarness.getSparkSqlConf());
    }

    public SQLContext sqlContext() {
        return sqlContext;
    }

    public JavaSparkContext jsc() {
        return jsc;
    }

    public HoodieSparkEngineContext context() {
        return context;
    }

    public String basePath() {
        return this.tempDir.toAbsolutePath().toString();
    }

    public String tablePath(String tableName) {
        return Paths.get(this.basePath(), tableName).toString();
    }

    @BeforeEach
    public synchronized void runBeforeEach() {
        boolean bl = this.initialized = spark != null;
        if (!this.initialized) {
            SparkConf sparkConf = this.conf();
            SparkRDDWriteClient.registerClasses((SparkConf)sparkConf);
            SparkRDDReadClient.addHoodieSupport((SparkConf)sparkConf);
            spark = SparkSession.builder().config(sparkConf).getOrCreate();
            sqlContext = spark.sqlContext();
            jsc = new JavaSparkContext(spark.sparkContext());
            context = new HoodieSparkEngineContext(jsc);
        }
    }

    @Test
    public void testHoodieSparkQuickstart() {
        String tableName = "spark_quick_start";
        String tablePath = this.tablePath(tableName);
        try {
            HoodieSparkQuickstart.runQuickstart((JavaSparkContext)jsc, (SparkSession)spark, (String)tableName, (String)tablePath);
        }
        finally {
            Utils.deleteRecursively((File)new File(tablePath));
        }
    }
}

