/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

public class HoodieExampleSparkUtils {
    private static Map<String, String> defaultConf() {
        HashMap<String, String> additionalConfigs = new HashMap<String, String>();
        additionalConfigs.put("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        additionalConfigs.put("spark.kryoserializer.buffer.max", "512m");
        additionalConfigs.put("spark.sql.extensions", "org.apache.spark.sql.hudi.HoodieSparkSessionExtension");
        return additionalConfigs;
    }

    public static SparkConf defaultSparkConf(String appName) {
        return HoodieExampleSparkUtils.buildSparkConf(appName, HoodieExampleSparkUtils.defaultConf());
    }

    public static SparkConf buildSparkConf(String appName, Map<String, String> additionalConfigs) {
        SparkConf sparkConf = new SparkConf().setAppName(appName);
        additionalConfigs.forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).set(arg_0, arg_1));
        return sparkConf;
    }

    public static SparkSession defaultSparkSession(String appName) {
        return HoodieExampleSparkUtils.buildSparkSession(appName, HoodieExampleSparkUtils.defaultConf());
    }

    public static SparkSession buildSparkSession(String appName, Map<String, String> additionalConfigs) {
        SparkSession.Builder builder = SparkSession.builder().appName(appName);
        additionalConfigs.forEach((arg_0, arg_1) -> ((SparkSession.Builder)builder).config(arg_0, arg_1));
        return builder.getOrCreate();
    }
}

