/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.common;

import java.util.List;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.examples.common.HoodieExampleDataGenerator;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.hudi.utilities.sources.JsonSource;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;

public class RandomJsonSource
extends JsonSource {
    private HoodieExampleDataGenerator<HoodieAvroPayload> dataGen = new HoodieExampleDataGenerator();

    public RandomJsonSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        super(props, sparkContext, sparkSession, schemaProvider);
    }

    protected InputBatch<JavaRDD<String>> fetchNewData(Option<String> lastCkptStr, long sourceLimit) {
        String commitTime = HoodieActiveTimeline.createNewInstantTime();
        List inserts = this.dataGen.convertToStringList(this.dataGen.generateInserts(commitTime, Integer.valueOf(20)));
        return new InputBatch(Option.of((Object)this.sparkContext.parallelize(inserts, 1)), commitTime);
    }
}

