/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.spark;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.QuickstartUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.examples.common.HoodieExampleDataGenerator;
import org.apache.hudi.examples.common.HoodieExampleSparkUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieDataSourceExample$ {
    public static HoodieDataSourceExample$ MODULE$;

    static {
        new HoodieDataSourceExample$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: HoodieDataSourceExample <tablePath> <tableName>");
            System.exit(1);
        }
        String tablePath = args[0];
        String tableName = args[1];
        SparkSession spark = HoodieExampleSparkUtils.defaultSparkSession("Hudi Spark basic example");
        HoodieExampleDataGenerator dataGen = new HoodieExampleDataGenerator();
        this.insertData(spark, tablePath, tableName, (HoodieExampleDataGenerator<HoodieAvroPayload>)dataGen);
        this.updateData(spark, tablePath, tableName, (HoodieExampleDataGenerator<HoodieAvroPayload>)dataGen);
        this.queryData(spark, tablePath, tableName, (HoodieExampleDataGenerator<HoodieAvroPayload>)dataGen);
        this.incrementalQuery(spark, tablePath, tableName);
        this.pointInTimeQuery(spark, tablePath, tableName);
        this.delete(spark, tablePath, tableName);
        this.deleteByPartition(spark, tablePath, tableName);
        spark.stop();
    }

    public void insertData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen) {
        String commitTime = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
        List inserts = dataGen.convertToStringList(dataGen.generateInserts(commitTime, Predef$.MODULE$.int2Integer(20)));
        Dataset df = spark.read().json(spark.sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inserts), 1, ClassTag$.MODULE$.apply(String.class)));
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(HoodieWriteConfig.TBL_NAME.key(), tableName).mode(SaveMode.Overwrite).save(tablePath);
    }

    public void queryData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen) {
        Dataset roViewDF = spark.read().format("org.apache.hudi").load(new StringBuilder(8).append(tablePath).append("/*/*/*/*").toString());
        roViewDF.createOrReplaceTempView("hudi_ro_table");
        spark.sql("select fare, begin_lon, begin_lat, ts from  hudi_ro_table where fare > 20.0").show();
        spark.sql("select _hoodie_commit_time, _hoodie_record_key, _hoodie_partition_path, rider, driver, fare from  hudi_ro_table").show();
    }

    public void updateData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen) {
        String commitTime = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
        List updates = dataGen.convertToStringList(dataGen.generateUpdates(commitTime, Predef$.MODULE$.int2Integer(10)));
        Dataset df = spark.read().json(spark.sparkContext().parallelize((Seq)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(updates), 1, ClassTag$.MODULE$.apply(String.class)));
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(HoodieWriteConfig.TBL_NAME.key(), tableName).mode(SaveMode.Append).save(tablePath);
    }

    public void delete(SparkSession spark, String tablePath, String tableName) {
        Dataset roViewDF = spark.read().format("org.apache.hudi").load(new StringBuilder(8).append(tablePath).append("/*/*/*/*").toString());
        roViewDF.createOrReplaceTempView("hudi_ro_table");
        Dataset df = spark.sql("select uuid, partitionpath, ts from  hudi_ro_table limit 2");
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL()).mode(SaveMode.Append).save(tablePath);
    }

    public void deleteByPartition(SparkSession spark, String tablePath, String tableName) {
        Dataset df = spark.emptyDataFrame();
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.DELETE_PARTITION_OPERATION_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HoodieExampleDataGenerator.DEFAULT_PARTITION_PATHS)).mkString(",")).mode(SaveMode.Append).save(tablePath);
    }

    public void incrementalQuery(SparkSession spark, String tablePath, String tableName) {
        String[] commits = (String[])spark.sql("select distinct(_hoodie_commit_time) as commitTime from hudi_ro_table order by commitTime").map((Function1 & Serializable & scala.Serializable)k -> k.getString(0), spark.implicits().newStringEncoder()).take(50);
        String beginTime = commits[commits.length - 2];
        Dataset incViewDF = spark.read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), beginTime).load(tablePath);
        incViewDF.createOrReplaceTempView("hudi_incr_table");
        spark.sql("select `_hoodie_commit_time`, fare, begin_lon, begin_lat, ts from hudi_incr_table where fare > 20.0").show();
    }

    public void pointInTimeQuery(SparkSession spark, String tablePath, String tableName) {
        String[] commits = (String[])spark.sql("select distinct(_hoodie_commit_time) as commitTime from  hudi_ro_table order by commitTime").map((Function1 & Serializable & scala.Serializable)k -> k.getString(0), spark.implicits().newStringEncoder()).take(50);
        String beginTime = "000";
        String endTime = commits[commits.length - 2];
        Dataset incViewDF = spark.read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key(), beginTime).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), endTime).load(tablePath);
        incViewDF.createOrReplaceTempView("hudi_incr_table");
        spark.sql("select `_hoodie_commit_time`, fare, begin_lon, begin_lat, ts from  hudi_incr_table where fare > 20.0").show();
    }

    private HoodieDataSourceExample$() {
        MODULE$ = this;
    }
}

