/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.spark;

import java.util.List;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.QuickstartUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.examples.common.HoodieExampleDataGenerator;
import org.apache.hudi.examples.common.HoodieExampleSparkUtils;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieMorCompactionJob$ {
    public static HoodieMorCompactionJob$ MODULE$;

    static {
        new HoodieMorCompactionJob$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: HoodieMorCompactionJob <tablePath> <tableName>");
            System.exit(1);
        }
        SparkSession spark = HoodieExampleSparkUtils.defaultSparkSession("Hudi MOR table compaction via Spark example");
        HoodieExampleDataGenerator dataGen = new HoodieExampleDataGenerator();
        String tablePath = args[0];
        String tableName = args[1];
        this.insertData(spark, tablePath, tableName, (HoodieExampleDataGenerator<HoodieAvroPayload>)dataGen, HoodieTableType.MERGE_ON_READ.name());
        this.updateData(spark, tablePath, tableName, (HoodieExampleDataGenerator<HoodieAvroPayload>)dataGen, HoodieTableType.MERGE_ON_READ.name());
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(tablePath).withSchema(HoodieExampleDataGenerator.TRIP_EXAMPLE_SCHEMA).withParallelism(2, 2).forTable(tableName).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Predef$.MODULE$.boolean2Boolean(true)).withMaxNumDeltaCommitsBeforeCompaction(1).build()).build();
        SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(spark.sparkContext())), cfg);
        try {
            try {
                Option instant = client.scheduleCompaction(Option.empty());
                client.compact((String)instant.get());
                client.clean();
            }
            catch (Exception e) {
                System.err.println(new Tuple2((Object)"Compaction failed due to", (Object)e));
            }
        }
        finally {
            client.close();
            spark.stop();
        }
    }

    public void insertData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen, String tableType) {
        String commitTime = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
        List inserts = dataGen.convertToStringList(dataGen.generateInserts(commitTime, Predef$.MODULE$.int2Integer(20)));
        Dataset df = spark.read().json(spark.sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(inserts).asScala(), 1, ClassTag$.MODULE$.apply(String.class)));
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).mode(SaveMode.Overwrite).save(tablePath);
    }

    public void updateData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen, String tableType) {
        String commitTime = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
        List updates = dataGen.convertToStringList(dataGen.generateUpdates(commitTime, Predef$.MODULE$.int2Integer(10)));
        Dataset df = spark.read().json(spark.sparkContext().parallelize((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(updates).asScala(), 1, ClassTag$.MODULE$.apply(String.class)));
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "partitionpath").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), tableType).mode(SaveMode.Append).save(tablePath);
    }

    private HoodieMorCompactionJob$() {
        MODULE$ = this;
    }
}

