/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.common;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;

public class HoodieExampleDataGenerator<T extends HoodieRecordPayload<T>> {
    public static final String DEFAULT_FIRST_PARTITION_PATH = "2020/01/01";
    public static final String DEFAULT_SECOND_PARTITION_PATH = "2020/01/02";
    public static final String DEFAULT_THIRD_PARTITION_PATH = "2020/01/03";
    public static final String[] DEFAULT_PARTITION_PATHS = new String[]{"2020/01/01", "2020/01/02", "2020/01/03"};
    public static String TRIP_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"ts\",\"type\": \"long\"},{\"name\": \"uuid\", \"type\": \"string\"},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\":\"fare\",\"type\": \"double\"}]}";
    public static Schema avroSchema = new Schema.Parser().parse(TRIP_EXAMPLE_SCHEMA);
    private static Random rand = new Random(46474747L);
    private final Map<Integer, KeyPartition> existingKeys;
    private final String[] partitionPaths;
    private int numExistingKeys;

    public HoodieExampleDataGenerator(String[] partitionPaths) {
        this(partitionPaths, new HashMap<Integer, KeyPartition>());
    }

    public HoodieExampleDataGenerator() {
        this(DEFAULT_PARTITION_PATHS);
    }

    public HoodieExampleDataGenerator(String[] partitionPaths, Map<Integer, KeyPartition> keyPartitionMap) {
        this.partitionPaths = Arrays.copyOf(partitionPaths, partitionPaths.length);
        this.existingKeys = keyPartitionMap;
    }

    public T generateRandomValue(HoodieKey key, String commitTime) {
        GenericRecord rec = this.generateGenericRecord(key.getRecordKey(), "rider-" + commitTime, "driver-" + commitTime, 0L);
        return (T)new HoodieAvroPayload(Option.of((Object)rec));
    }

    public GenericRecord generateGenericRecord(String rowKey, String riderName, String driverName, long timestamp) {
        GenericData.Record rec = new GenericData.Record(avroSchema);
        rec.put("uuid", (Object)rowKey);
        rec.put("ts", (Object)timestamp);
        rec.put("rider", (Object)riderName);
        rec.put("driver", (Object)driverName);
        rec.put("begin_lat", (Object)rand.nextDouble());
        rec.put("begin_lon", (Object)rand.nextDouble());
        rec.put("end_lat", (Object)rand.nextDouble());
        rec.put("end_lon", (Object)rand.nextDouble());
        rec.put("fare", (Object)(rand.nextDouble() * 100.0));
        return rec;
    }

    public List<HoodieRecord<T>> generateInserts(String commitTime, Integer n) {
        return this.generateInsertsStream(commitTime, n).collect(Collectors.toList());
    }

    public Stream<HoodieRecord<T>> generateInsertsStream(String commitTime, Integer n) {
        int currSize = this.getNumExistingKeys();
        return IntStream.range(0, n).boxed().map(i -> {
            String partitionPath = this.partitionPaths[rand.nextInt(this.partitionPaths.length)];
            HoodieKey key = new HoodieKey(UUID.randomUUID().toString(), partitionPath);
            KeyPartition kp = new KeyPartition();
            kp.key = key;
            kp.partitionPath = partitionPath;
            this.existingKeys.put(currSize + i, kp);
            ++this.numExistingKeys;
            return new HoodieRecord(key, this.generateRandomValue(key, commitTime));
        });
    }

    public List<HoodieRecord<T>> generateUpdates(String commitTime, Integer n) {
        ArrayList<HoodieRecord<T>> updates = new ArrayList<HoodieRecord<T>>();
        for (int i = 0; i < n; ++i) {
            KeyPartition kp = this.existingKeys.get(rand.nextInt(this.numExistingKeys - 1));
            HoodieRecord<T> record = this.generateUpdateRecord(kp.key, commitTime);
            updates.add(record);
        }
        return updates;
    }

    public HoodieRecord<T> generateUpdateRecord(HoodieKey key, String commitTime) {
        return new HoodieRecord(key, this.generateRandomValue(key, commitTime));
    }

    private Option<String> convertToString(HoodieRecord<T> record) {
        try {
            String str = HoodieAvroUtils.bytesToAvro((byte[])((HoodieAvroPayload)record.getData()).getRecordBytes(), (Schema)avroSchema).toString();
            str = "{" + str.substring(str.indexOf("\"ts\":"));
            return Option.of((Object)str.replaceAll("}", ", \"partitionpath\": \"" + record.getPartitionPath() + "\"}"));
        }
        catch (IOException e) {
            return Option.empty();
        }
    }

    public List<String> convertToStringList(List<HoodieRecord<T>> records) {
        return records.stream().map(this::convertToString).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
    }

    public int getNumExistingKeys() {
        return this.numExistingKeys;
    }

    public void close() {
        this.existingKeys.clear();
    }

    public static class KeyPartition
    implements Serializable {
        HoodieKey key;
        String partitionPath;
    }
}

