/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.spark;

import java.util.List;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.QuickstartUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.examples.common.HoodieExampleDataGenerator;
import org.apache.hudi.examples.common.HoodieExampleSparkUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieDataSourceExample$ {
    public static final HoodieDataSourceExample$ MODULE$;

    static {
        new HoodieDataSourceExample$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: HoodieDataSourceExample <tablePath> <tableName>");
            System.exit(1);
        }
        String tablePath = args[0];
        String tableName = args[1];
        SparkSession spark = HoodieExampleSparkUtils.defaultSparkSession("Hudi Spark basic example");
        HoodieExampleDataGenerator<HoodieAvroPayload> dataGen = new HoodieExampleDataGenerator<HoodieAvroPayload>();
        this.insertData(spark, tablePath, tableName, dataGen);
        this.updateData(spark, tablePath, tableName, dataGen);
        this.queryData(spark, tablePath, tableName, dataGen);
        this.incrementalQuery(spark, tablePath, tableName);
        this.pointInTimeQuery(spark, tablePath, tableName);
        spark.stop();
    }

    public void insertData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen) {
        String commitTime = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
        List<String> inserts = dataGen.convertToStringList(dataGen.generateInserts(commitTime, Predef$.MODULE$.int2Integer(20)));
        spark.sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(inserts), 2, ClassTag$.MODULE$.apply(String.class));
        Dataset df = spark.read().json(spark.sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(inserts), 1, ClassTag$.MODULE$.apply(String.class)));
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY(), "partitionpath").option("hoodie.table.name", tableName).mode(SaveMode.Overwrite).save(tablePath);
    }

    public void queryData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen) {
        Dataset roViewDF = spark.read().format("org.apache.hudi").load(new StringBuilder().append((Object)tablePath).append((Object)"/*/*/*/*").toString());
        roViewDF.createOrReplaceTempView("hudi_ro_table");
        spark.sql("select fare, begin_lon, begin_lat, ts from  hudi_ro_table where fare > 20.0").show();
        spark.sql("select _hoodie_commit_time, _hoodie_record_key, _hoodie_partition_path, rider, driver, fare from  hudi_ro_table").show();
    }

    public void updateData(SparkSession spark, String tablePath, String tableName, HoodieExampleDataGenerator<HoodieAvroPayload> dataGen) {
        String commitTime = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
        List<String> updates = dataGen.convertToStringList(dataGen.generateUpdates(commitTime, Predef$.MODULE$.int2Integer(10)));
        Dataset df = spark.read().json(spark.sparkContext().parallelize((Seq)JavaConversions$.MODULE$.asScalaBuffer(updates), 1, ClassTag$.MODULE$.apply(String.class)));
        df.write().format("org.apache.hudi").options(QuickstartUtils.getQuickstartWriteConfigs()).option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY(), "ts").option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY(), "uuid").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY(), "partitionpath").option("hoodie.table.name", tableName).mode(SaveMode.Append).save(tablePath);
    }

    public void incrementalQuery(SparkSession spark, String tablePath, String tableName) {
        String[] commits = (String[])spark.sql("select distinct(_hoodie_commit_time) as commitTime from hudi_ro_table order by commitTime").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row k) {
                return k.getString(0);
            }
        }, spark.implicits().newStringEncoder()).take(50);
        String beginTime = commits[commits.length - 2];
        Dataset incViewDF = spark.read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME_OPT_KEY(), beginTime).load(tablePath);
        incViewDF.createOrReplaceTempView("hudi_incr_table");
        spark.sql("select `_hoodie_commit_time`, fare, begin_lon, begin_lat, ts from hudi_incr_table where fare > 20.0").show();
    }

    public void pointInTimeQuery(SparkSession spark, String tablePath, String tableName) {
        String[] commits = (String[])spark.sql("select distinct(_hoodie_commit_time) as commitTime from  hudi_ro_table order by commitTime").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row k) {
                return k.getString(0);
            }
        }, spark.implicits().newStringEncoder()).take(50);
        String beginTime = "000";
        String endTime = commits[commits.length - 2];
        Dataset incViewDF = spark.read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE_OPT_KEY(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME_OPT_KEY(), beginTime).option(DataSourceReadOptions$.MODULE$.END_INSTANTTIME_OPT_KEY(), endTime).load(tablePath);
        incViewDF.createOrReplaceTempView("hudi_incr_table");
        spark.sql("select `_hoodie_commit_time`, fare, begin_lon, begin_lat, ts from  hudi_incr_table where fare > 20.0").show();
    }

    private HoodieDataSourceExample$() {
        MODULE$ = this;
    }
}

