/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.examples.java;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.examples.common.HoodieExampleDataGenerator;
import org.apache.hudi.index.HoodieIndex;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieJavaWriteClientExample {
    private static final Logger LOG = LogManager.getLogger(HoodieJavaWriteClientExample.class);
    private static String tableType = HoodieTableType.COPY_ON_WRITE.name();

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: HoodieJavaWriteClientExample <tablePath> <tableName>");
            System.exit(1);
        }
        String tablePath = args[0];
        String tableName = args[1];
        HoodieExampleDataGenerator dataGen = new HoodieExampleDataGenerator();
        Configuration hadoopConf = new Configuration();
        Path path = new Path(tablePath);
        FileSystem fs = FSUtils.getFs((String)tablePath, (Configuration)hadoopConf);
        if (!fs.exists(path)) {
            HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setTableName(tableName).setPayloadClassName(HoodieAvroPayload.class.getName()).initTable(hadoopConf, tablePath);
        }
        HoodieWriteConfig cfg = HoodieWriteConfig.newBuilder().withPath(tablePath).withSchema(HoodieExampleDataGenerator.TRIP_EXAMPLE_SCHEMA).withParallelism(2, 2).withDeleteParallelism(2).forTable(tableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().archiveCommitsWith(20, 30).build()).build();
        HoodieJavaWriteClient client = new HoodieJavaWriteClient((HoodieEngineContext)new HoodieJavaEngineContext(hadoopConf), cfg);
        String newCommitTime = client.startCommit();
        LOG.info((Object)("Starting commit " + newCommitTime));
        List records = dataGen.generateInserts(newCommitTime, 10);
        ArrayList recordsSoFar = new ArrayList(records);
        List writeRecords = recordsSoFar.stream().map(r -> new HoodieRecord(r)).collect(Collectors.toList());
        client.upsert(writeRecords, newCommitTime);
        newCommitTime = client.startCommit();
        LOG.info((Object)("Starting commit " + newCommitTime));
        List toBeUpdated = dataGen.generateUpdates(newCommitTime, 2);
        records.addAll(toBeUpdated);
        recordsSoFar.addAll(toBeUpdated);
        writeRecords = recordsSoFar.stream().map(r -> new HoodieRecord(r)).collect(Collectors.toList());
        client.upsert(writeRecords, newCommitTime);
        newCommitTime = client.startCommit();
        LOG.info((Object)("Starting commit " + newCommitTime));
        int numToDelete = recordsSoFar.size() / 2;
        List toBeDeleted = recordsSoFar.stream().map(HoodieRecord::getKey).limit(numToDelete).collect(Collectors.toList());
        client.delete(toBeDeleted, newCommitTime);
        client.close();
    }
}

