/*
 * Decompiled with CFR 0.152.
 */
package avro.shaded.com.google.common.collect;

import avro.shaded.com.google.common.annotations.Beta;
import avro.shaded.com.google.common.annotations.GwtCompatible;
import avro.shaded.com.google.common.base.Objects;
import avro.shaded.com.google.common.collect.Collections2;
import avro.shaded.com.google.common.collect.ForwardingObject;
import avro.shaded.com.google.common.collect.Iterators;
import avro.shaded.com.google.common.collect.ObjectArrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public abstract class ForwardingCollection<E>
extends ForwardingObject
implements Collection<E> {
    protected ForwardingCollection() {
    }

    @Override
    protected abstract Collection<E> delegate();

    @Override
    public Iterator<E> iterator() {
        return this.delegate().iterator();
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public boolean removeAll(Collection<?> collection2) {
        return this.delegate().removeAll(collection2);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate().contains(object);
    }

    @Override
    public boolean add(E element) {
        return this.delegate().add(element);
    }

    @Override
    public boolean remove(Object object) {
        return this.delegate().remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection2) {
        return this.delegate().containsAll(collection2);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection2) {
        return this.delegate().addAll(collection2);
    }

    @Override
    public boolean retainAll(Collection<?> collection2) {
        return this.delegate().retainAll(collection2);
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array2) {
        return this.delegate().toArray(array2);
    }

    @Beta
    protected boolean standardContains(@Nullable Object object) {
        return Iterators.contains(this.iterator(), object);
    }

    @Beta
    protected boolean standardContainsAll(Collection<?> collection2) {
        for (Object o : collection2) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Beta
    protected boolean standardAddAll(Collection<? extends E> collection2) {
        return Iterators.addAll(this, collection2.iterator());
    }

    @Beta
    protected boolean standardRemove(@Nullable Object object) {
        Iterator<E> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (!Objects.equal(iterator2.next(), object)) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Beta
    protected boolean standardRemoveAll(Collection<?> collection2) {
        return Iterators.removeAll(this.iterator(), collection2);
    }

    @Beta
    protected boolean standardRetainAll(Collection<?> collection2) {
        return Iterators.retainAll(this.iterator(), collection2);
    }

    @Beta
    protected void standardClear() {
        Iterator<E> iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            iterator2.remove();
        }
    }

    @Beta
    protected boolean standardIsEmpty() {
        return !this.iterator().hasNext();
    }

    @Beta
    protected String standardToString() {
        return Collections2.toStringImpl(this);
    }

    @Beta
    protected Object[] standardToArray() {
        Object[] newArray = new Object[this.size()];
        return this.toArray(newArray);
    }

    @Beta
    protected <T> T[] standardToArray(T[] array2) {
        return ObjectArrays.toArrayImpl(this, array2);
    }
}

