/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.bijection;

import com.twitter.bijection.AbstractInjection;
import com.twitter.bijection.AtomicSharedState;
import com.twitter.bijection.Injection;
import com.twitter.bijection.Inversion$;
import com.twitter.bijection.StringCodec;
import com.twitter.bijection.StringInjections;
import com.twitter.bijection.StringInjections$;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.UUID;
import scala.Function0;
import scala.Serializable;
import scala.Tuple2;
import scala.util.Try;

public abstract class StringInjections$class {
    public static Injection withEncoding(StringInjections $this, String encoding) {
        return new AbstractInjection<String, byte[]>($this, encoding){
            public transient AtomicSharedState<Tuple2<CharsetDecoder, CharBuffer>> com$twitter$bijection$StringInjections$$anon$$decRef;
            public final String encoding$1;

            public AtomicSharedState<Tuple2<CharsetDecoder, CharBuffer>> com$twitter$bijection$StringInjections$$anon$$mkSharedState() {
                return new AtomicSharedState<Tuple2<CharsetDecoder, CharBuffer>>((Function0<Tuple2<CharsetDecoder, CharBuffer>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ StringInjections$.anon.1 $outer;

                    public final Tuple2<CharsetDecoder, CharBuffer> apply() {
                        CharsetDecoder dec = Charset.forName(this.$outer.encoding$1).newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT);
                        CharBuffer buf = CharBuffer.allocate(1024);
                        return new Tuple2((Object)dec, (Object)buf);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public byte[] apply(String s) {
                return s.getBytes(this.encoding$1);
            }

            public Try<String> invert(byte[] b) {
                return Inversion$.MODULE$.attempt(ByteBuffer.wrap(b), new Serializable(this, b){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ StringInjections$.anon.1 $outer;
                    private final byte[] b$1;

                    public final String apply(ByteBuffer bb) {
                        if (this.$outer.com$twitter$bijection$StringInjections$$anon$$decRef == null) {
                            this.$outer.com$twitter$bijection$StringInjections$$anon$$decRef = this.$outer.com$twitter$bijection$StringInjections$$anon$$mkSharedState();
                        }
                        Tuple2<CharsetDecoder, CharBuffer> decBuf = this.$outer.com$twitter$bijection$StringInjections$$anon$$decRef.get();
                        CharsetDecoder dec = (CharsetDecoder)decBuf._1();
                        CharBuffer buf = (CharBuffer)decBuf._2();
                        int maxSpace = (int)((double)this.b$1.length * (double)dec.maxCharsPerByte()) + 1;
                        CharBuffer thisBuf = maxSpace > buf.limit() ? CharBuffer.allocate(maxSpace) : buf;
                        this.assertUnderFlow$1(dec.reset().decode(bb, thisBuf, true));
                        this.assertUnderFlow$1(dec.flush(thisBuf));
                        thisBuf.flip();
                        String str = thisBuf.toString();
                        buf.clear();
                        this.$outer.com$twitter$bijection$StringInjections$$anon$$decRef.release(decBuf);
                        return str;
                    }

                    private final void assertUnderFlow$1(CoderResult cr) {
                        if (!cr.isUnderflow()) {
                            cr.throwException();
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.b$1 = b$1;
                    }
                });
            }
            {
                this.encoding$1 = encoding$1;
                this.com$twitter$bijection$StringInjections$$anon$$decRef = null;
            }
        };
    }

    public static void $init$(StringInjections $this) {
        $this.com$twitter$bijection$StringInjections$_setter_$utf8_$eq($this.withEncoding("UTF-8"));
        $this.com$twitter$bijection$StringInjections$_setter_$url2String_$eq(new AbstractInjection<URL, String>($this){

            public String apply(URL u) {
                return u.toString();
            }

            public Try<URL> invert(String s) {
                return Inversion$.MODULE$.attempt(s, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final URL apply(String x$1) {
                        return new URL(x$1);
                    }
                });
            }
        });
        $this.com$twitter$bijection$StringInjections$_setter_$uuid2String_$eq(new AbstractInjection<UUID, String>($this){

            public String apply(UUID uuid) {
                return uuid.toString();
            }

            public Try<UUID> invert(String s) {
                return Inversion$.MODULE$.attempt(s, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final UUID apply(String x$2) {
                        return UUID.fromString(x$2);
                    }
                });
            }
        });
        $this.com$twitter$bijection$StringInjections$_setter_$string2UrlEncodedString_$eq(new AbstractInjection<String, String>($this){

            public String apply(String a) {
                return URLEncoder.encode(a, "UTF-8");
            }

            public Try<String> invert(String b) {
                return Inversion$.MODULE$.attempt(new StringCodec.URLEncodedString(b), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String s) {
                        return URLDecoder.decode(s, "UTF-8");
                    }
                });
            }
        });
    }
}

