/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.apibuilder;

import io.javalin.Handler;
import io.javalin.Javalin;
import io.javalin.apibuilder.CrudHandler;
import io.javalin.apibuilder.EndpointGroup;
import io.javalin.security.Role;
import io.javalin.websocket.WsHandler;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ApiBuilder {
    private static Javalin staticJavalin;
    private static Deque<String> pathDeque;

    public static void setStaticJavalin(@NotNull Javalin javalin) {
        staticJavalin = javalin;
    }

    public static void clearStaticJavalin() {
        staticJavalin = null;
    }

    public static void path(@NotNull String path, @NotNull EndpointGroup endpointGroup) {
        path = path.startsWith("/") ? path : "/" + path;
        pathDeque.addLast(path);
        endpointGroup.addEndpoints();
        pathDeque.removeLast();
    }

    private static String prefixPath(@NotNull String path) {
        return String.join((CharSequence)"", pathDeque) + (path.startsWith("/") || path.isEmpty() ? path : "/" + path);
    }

    private static Javalin staticInstance() {
        if (staticJavalin == null) {
            throw new IllegalStateException("The static API can only be used within a routes() call.");
        }
        return staticJavalin;
    }

    public static void get(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(path), handler);
    }

    public static void get(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void get(@NotNull Handler handler) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(""), handler);
    }

    public static void get(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void post(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(path), handler);
    }

    public static void post(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void post(@NotNull Handler handler) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(""), handler);
    }

    public static void post(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void put(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(path), handler);
    }

    public static void put(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void put(@NotNull Handler handler) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(""), handler);
    }

    public static void put(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().put(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void patch(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(path), handler);
    }

    public static void patch(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void patch(@NotNull Handler handler) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(""), handler);
    }

    public static void patch(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void delete(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(path), handler);
    }

    public static void delete(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void delete(@NotNull Handler handler) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(""), handler);
    }

    public static void delete(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void head(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(path), handler);
    }

    public static void head(@NotNull String path, @NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(path), handler, permittedRoles);
    }

    public static void head(@NotNull Handler handler) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(""), handler);
    }

    public static void head(@NotNull Handler handler, @NotNull Set<Role> permittedRoles) {
        ApiBuilder.staticInstance().head(ApiBuilder.prefixPath(""), handler, permittedRoles);
    }

    public static void before(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().before(ApiBuilder.prefixPath(path), handler);
    }

    public static void before(@NotNull Handler handler) {
        ApiBuilder.staticInstance().before(ApiBuilder.prefixPath("/*"), handler);
    }

    public static void after(@NotNull String path, @NotNull Handler handler) {
        ApiBuilder.staticInstance().after(ApiBuilder.prefixPath(path), handler);
    }

    public static void after(@NotNull Handler handler) {
        ApiBuilder.staticInstance().after(ApiBuilder.prefixPath("/*"), handler);
    }

    public static void ws(@NotNull String path, @NotNull Consumer<WsHandler> ws) {
        ApiBuilder.staticInstance().ws(ApiBuilder.prefixPath(path), ws);
    }

    public static void ws(@NotNull Consumer<WsHandler> ws) {
        ApiBuilder.staticInstance().ws(ApiBuilder.prefixPath(""), ws);
    }

    public static void crud(@NotNull String path, @NotNull CrudHandler crudHandler) {
        ApiBuilder.crud(path, crudHandler, new HashSet<Role>());
    }

    public static void crud(@NotNull String path, @NotNull CrudHandler crudHandler, @NotNull Set<Role> permittedRoles) {
        String string = path = path.startsWith("/") ? path : "/" + path;
        if (path.startsWith("/:")) {
            throw new IllegalArgumentException("CrudHandler requires a resource base at the beginning of the provided path e.g. '/users/:user-id'");
        }
        if (!path.contains("/:") || path.lastIndexOf("/") > path.lastIndexOf("/:")) {
            throw new IllegalArgumentException("CrudHandler requires a path-parameter at the end of the provided path e.g. '/users/:user-id'");
        }
        String SEPARATOR = "/:";
        String resourceBase = path.substring(0, path.lastIndexOf(SEPARATOR));
        String resourceId = path.substring(path.lastIndexOf(SEPARATOR) + SEPARATOR.length());
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(path), ctx -> crudHandler.getOne(ctx, ctx.pathParam(resourceId)), permittedRoles);
        ApiBuilder.staticInstance().get(ApiBuilder.prefixPath(resourceBase), crudHandler::getAll, permittedRoles);
        ApiBuilder.staticInstance().post(ApiBuilder.prefixPath(resourceBase), crudHandler::create, permittedRoles);
        ApiBuilder.staticInstance().patch(ApiBuilder.prefixPath(path), ctx -> crudHandler.update(ctx, ctx.pathParam(resourceId)), permittedRoles);
        ApiBuilder.staticInstance().delete(ApiBuilder.prefixPath(path), ctx -> crudHandler.delete(ctx, ctx.pathParam(resourceId)), permittedRoles);
    }

    static {
        pathDeque = new ArrayDeque<String>();
    }
}

