/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;

class ArrayAccessor {
    ArrayAccessor() {
    }

    static void writeArray(boolean[] data, Encoder out) throws IOException {
        int size = data.length;
        out.setItemCount(size);
        for (int i = 0; i < size; ++i) {
            out.startItem();
            out.writeBoolean(data[i]);
        }
    }

    static void writeArray(short[] data, Encoder out) throws IOException {
        int size = data.length;
        out.setItemCount(size);
        for (int i = 0; i < size; ++i) {
            out.startItem();
            out.writeInt(data[i]);
        }
    }

    static void writeArray(char[] data, Encoder out) throws IOException {
        int size = data.length;
        out.setItemCount(size);
        for (int i = 0; i < size; ++i) {
            out.startItem();
            out.writeInt(data[i]);
        }
    }

    static void writeArray(int[] data, Encoder out) throws IOException {
        int size = data.length;
        out.setItemCount(size);
        for (int i = 0; i < size; ++i) {
            out.startItem();
            out.writeInt(data[i]);
        }
    }

    static void writeArray(long[] data, Encoder out) throws IOException {
        int size = data.length;
        out.setItemCount(size);
        for (int i = 0; i < size; ++i) {
            out.startItem();
            out.writeLong(data[i]);
        }
    }

    static void writeArray(float[] data, Encoder out) throws IOException {
        int size = data.length;
        out.setItemCount(size);
        for (int i = 0; i < size; ++i) {
            out.startItem();
            out.writeFloat(data[i]);
        }
    }

    static void writeArray(double[] data, Encoder out) throws IOException {
        int size = data.length;
        out.setItemCount(size);
        for (int i = 0; i < size; ++i) {
            out.startItem();
            out.writeDouble(data[i]);
        }
    }

    static Object readArray(Object array2, Class<?> elementType, long l, ResolvingDecoder in) throws IOException {
        if (elementType == Integer.TYPE) {
            return ArrayAccessor.readArray((int[])array2, l, in);
        }
        if (elementType == Long.TYPE) {
            return ArrayAccessor.readArray((long[])array2, l, in);
        }
        if (elementType == Float.TYPE) {
            return ArrayAccessor.readArray((float[])array2, l, in);
        }
        if (elementType == Double.TYPE) {
            return ArrayAccessor.readArray((double[])array2, l, in);
        }
        if (elementType == Boolean.TYPE) {
            return ArrayAccessor.readArray((boolean[])array2, l, in);
        }
        if (elementType == Character.TYPE) {
            return ArrayAccessor.readArray((char[])array2, l, in);
        }
        if (elementType == Short.TYPE) {
            return ArrayAccessor.readArray((short[])array2, l, in);
        }
        return null;
    }

    static boolean[] readArray(boolean[] array2, long l, ResolvingDecoder in) throws IOException {
        int index = 0;
        do {
            int limit;
            if (array2.length < (limit = index + (int)l)) {
                array2 = Arrays.copyOf(array2, limit);
            }
            while (index < limit) {
                array2[index] = in.readBoolean();
                ++index;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array2;
    }

    static int[] readArray(int[] array2, long l, ResolvingDecoder in) throws IOException {
        int index = 0;
        do {
            int limit;
            if (array2.length < (limit = index + (int)l)) {
                array2 = Arrays.copyOf(array2, limit);
            }
            while (index < limit) {
                array2[index] = in.readInt();
                ++index;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array2;
    }

    static short[] readArray(short[] array2, long l, ResolvingDecoder in) throws IOException {
        int index = 0;
        do {
            int limit;
            if (array2.length < (limit = index + (int)l)) {
                array2 = Arrays.copyOf(array2, limit);
            }
            while (index < limit) {
                array2[index] = (short)in.readInt();
                ++index;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array2;
    }

    static char[] readArray(char[] array2, long l, ResolvingDecoder in) throws IOException {
        int index = 0;
        do {
            int limit;
            if (array2.length < (limit = index + (int)l)) {
                array2 = Arrays.copyOf(array2, limit);
            }
            while (index < limit) {
                array2[index] = (char)in.readInt();
                ++index;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array2;
    }

    static long[] readArray(long[] array2, long l, ResolvingDecoder in) throws IOException {
        int index = 0;
        do {
            int limit;
            if (array2.length < (limit = index + (int)l)) {
                array2 = Arrays.copyOf(array2, limit);
            }
            while (index < limit) {
                array2[index] = in.readLong();
                ++index;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array2;
    }

    static float[] readArray(float[] array2, long l, ResolvingDecoder in) throws IOException {
        int index = 0;
        do {
            int limit;
            if (array2.length < (limit = index + (int)l)) {
                array2 = Arrays.copyOf(array2, limit);
            }
            while (index < limit) {
                array2[index] = in.readFloat();
                ++index;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array2;
    }

    static double[] readArray(double[] array2, long l, ResolvingDecoder in) throws IOException {
        int index = 0;
        do {
            int limit;
            if (array2.length < (limit = index + (int)l)) {
                array2 = Arrays.copyOf(array2, limit);
            }
            while (index < limit) {
                array2[index] = in.readDouble();
                ++index;
            }
        } while ((l = in.arrayNext()) > 0L);
        return array2;
    }
}

