/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ProcedureInfo
implements Cloneable {
    private final long procId;
    private final String procName;
    private final String procOwner;
    private final ProcedureProtos.ProcedureState procState;
    private final long parentId;
    private final NonceKey nonceKey;
    private final ErrorHandlingProtos.ForeignExceptionMessage exception;
    private final long lastUpdate;
    private final long startTime;
    private final byte[] result;
    private long clientAckTime = -1L;

    @InterfaceAudience.Private
    public ProcedureInfo(long procId, String procName, String procOwner, ProcedureProtos.ProcedureState procState, long parentId, NonceKey nonceKey, ErrorHandlingProtos.ForeignExceptionMessage exception, long lastUpdate, long startTime, byte[] result) {
        this.procId = procId;
        this.procName = procName;
        this.procOwner = procOwner;
        this.procState = procState;
        this.parentId = parentId;
        this.nonceKey = nonceKey;
        this.lastUpdate = lastUpdate;
        this.startTime = startTime;
        this.exception = exception;
        this.result = result;
    }

    @SuppressWarnings(value={"CN_IDIOM_NO_SUPER_CALL"}, justification="Intentional; calling super class clone doesn't make sense here.")
    public ProcedureInfo clone() {
        return new ProcedureInfo(this.procId, this.procName, this.procOwner, this.procState, this.parentId, this.nonceKey, this.exception, this.lastUpdate, this.startTime, this.result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Procedure=");
        sb.append(this.procName);
        sb.append(" (id=");
        sb.append(this.procId);
        if (this.hasParentId()) {
            sb.append(", parent=");
            sb.append(this.parentId);
        }
        if (this.hasOwner()) {
            sb.append(", owner=");
            sb.append(this.procOwner);
        }
        sb.append(", state=");
        sb.append((Object)this.procState);
        long now = EnvironmentEdgeManager.currentTime();
        sb.append(", startTime=");
        sb.append(StringUtils.formatTime((long)(now - this.startTime)));
        sb.append(" ago, lastUpdate=");
        sb.append(StringUtils.formatTime((long)(now - this.startTime)));
        sb.append(" ago");
        if (this.isFailed()) {
            sb.append(", exception=\"");
            sb.append(this.getExceptionMessage());
            sb.append("\"");
        }
        sb.append(")");
        return sb.toString();
    }

    public long getProcId() {
        return this.procId;
    }

    public String getProcName() {
        return this.procName;
    }

    private boolean hasOwner() {
        return this.procOwner != null;
    }

    public String getProcOwner() {
        return this.procOwner;
    }

    public ProcedureProtos.ProcedureState getProcState() {
        return this.procState;
    }

    public boolean hasParentId() {
        return this.parentId != -1L;
    }

    public long getParentId() {
        return this.parentId;
    }

    public NonceKey getNonceKey() {
        return this.nonceKey;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public IOException getException() {
        if (this.isFailed()) {
            return ForeignExceptionUtil.toIOException(this.exception);
        }
        return null;
    }

    @InterfaceAudience.Private
    public ErrorHandlingProtos.ForeignExceptionMessage getForeignExceptionMessage() {
        return this.exception;
    }

    public String getExceptionCause() {
        assert (this.isFailed());
        return this.exception.getGenericException().getClassName();
    }

    public String getExceptionMessage() {
        assert (this.isFailed());
        return this.exception.getGenericException().getMessage();
    }

    public String getExceptionFullMessage() {
        assert (this.isFailed());
        return this.getExceptionCause() + " - " + this.getExceptionMessage();
    }

    public boolean hasResultData() {
        return this.result != null;
    }

    public byte[] getResult() {
        return this.result;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public long executionTime() {
        return this.lastUpdate - this.startTime;
    }

    @InterfaceAudience.Private
    public boolean hasClientAckTime() {
        return this.clientAckTime != -1L;
    }

    @InterfaceAudience.Private
    public long getClientAckTime() {
        return this.clientAckTime;
    }

    @InterfaceAudience.Private
    public void setClientAckTime(long timestamp) {
        this.clientAckTime = timestamp;
    }

    @InterfaceAudience.Private
    public static ProcedureProtos.Procedure convertToProcedureProto(ProcedureInfo procInfo) {
        ProcedureProtos.Procedure.Builder builder = ProcedureProtos.Procedure.newBuilder();
        builder.setClassName(procInfo.getProcName());
        builder.setProcId(procInfo.getProcId());
        builder.setStartTime(procInfo.getStartTime());
        builder.setState(procInfo.getProcState());
        builder.setLastUpdate(procInfo.getLastUpdate());
        if (procInfo.hasParentId()) {
            builder.setParentId(procInfo.getParentId());
        }
        if (procInfo.getProcOwner() != null) {
            builder.setOwner(procInfo.getProcOwner());
        }
        if (procInfo.isFailed()) {
            builder.setException(procInfo.getForeignExceptionMessage());
        }
        if (procInfo.hasResultData()) {
            builder.setResult(ByteStringer.wrap(procInfo.getResult()));
        }
        return builder.build();
    }

    @InterfaceAudience.Private
    public static ProcedureInfo convert(ProcedureProtos.Procedure procProto) {
        NonceKey nonceKey = null;
        if (procProto.getNonce() != 0L) {
            nonceKey = new NonceKey(procProto.getNonceGroup(), procProto.getNonce());
        }
        return new ProcedureInfo(procProto.getProcId(), procProto.getClassName(), procProto.getOwner(), procProto.getState(), procProto.hasParentId() ? procProto.getParentId() : -1L, nonceKey, procProto.hasException() ? procProto.getException() : null, procProto.getLastUpdate(), procProto.getStartTime(), procProto.hasResult() ? procProto.getResult().toByteArray() : null);
    }

    @InterfaceAudience.Private
    public static boolean isProcedureOwner(ProcedureInfo procInfo, User user) {
        if (user == null) {
            return false;
        }
        String procOwner = procInfo.getProcOwner();
        if (procOwner == null) {
            return false;
        }
        return procOwner.equals(user.getShortName());
    }
}

