/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaTableUtil {
    private static final Log LOG = LogFactory.getLog(QuotaTableUtil.class);
    public static final TableName QUOTA_TABLE_NAME = TableName.valueOf(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, "quota");
    protected static final byte[] QUOTA_FAMILY_INFO = Bytes.toBytes("q");
    protected static final byte[] QUOTA_FAMILY_USAGE = Bytes.toBytes("u");
    protected static final byte[] QUOTA_QUALIFIER_SETTINGS = Bytes.toBytes("s");
    protected static final byte[] QUOTA_QUALIFIER_SETTINGS_PREFIX = Bytes.toBytes("s.");
    protected static final byte[] QUOTA_USER_ROW_KEY_PREFIX = Bytes.toBytes("u.");
    protected static final byte[] QUOTA_TABLE_ROW_KEY_PREFIX = Bytes.toBytes("t.");
    protected static final byte[] QUOTA_NAMESPACE_ROW_KEY_PREFIX = Bytes.toBytes("n.");

    public static QuotaProtos.Quotas getTableQuota(Connection connection, TableName table) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getTableRowKey(table));
    }

    public static QuotaProtos.Quotas getNamespaceQuota(Connection connection, String namespace) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getNamespaceRowKey(namespace));
    }

    public static QuotaProtos.Quotas getUserQuota(Connection connection, String user) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getUserRowKey(user));
    }

    public static QuotaProtos.Quotas getUserQuota(Connection connection, String user, TableName table) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getUserRowKey(user), QuotaTableUtil.getSettingsQualifierForUserTable(table));
    }

    public static QuotaProtos.Quotas getUserQuota(Connection connection, String user, String namespace) throws IOException {
        return QuotaTableUtil.getQuotas(connection, QuotaTableUtil.getUserRowKey(user), QuotaTableUtil.getSettingsQualifierForUserNamespace(namespace));
    }

    private static QuotaProtos.Quotas getQuotas(Connection connection, byte[] rowKey) throws IOException {
        return QuotaTableUtil.getQuotas(connection, rowKey, QUOTA_QUALIFIER_SETTINGS);
    }

    private static QuotaProtos.Quotas getQuotas(Connection connection, byte[] rowKey, byte[] qualifier) throws IOException {
        Get get2 = new Get(rowKey);
        get2.addColumn(QUOTA_FAMILY_INFO, qualifier);
        Result result = QuotaTableUtil.doGet(connection, get2);
        if (result.isEmpty()) {
            return null;
        }
        return QuotaTableUtil.quotasFromData(result.getValue(QUOTA_FAMILY_INFO, qualifier));
    }

    public static Get makeGetForTableQuotas(TableName table) {
        Get get2 = new Get(QuotaTableUtil.getTableRowKey(table));
        get2.addFamily(QUOTA_FAMILY_INFO);
        return get2;
    }

    public static Get makeGetForNamespaceQuotas(String namespace) {
        Get get2 = new Get(QuotaTableUtil.getNamespaceRowKey(namespace));
        get2.addFamily(QUOTA_FAMILY_INFO);
        return get2;
    }

    public static Get makeGetForUserQuotas(String user, Iterable<TableName> tables, Iterable<String> namespaces) {
        Get get2 = new Get(QuotaTableUtil.getUserRowKey(user));
        get2.addColumn(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        for (TableName table : tables) {
            get2.addColumn(QUOTA_FAMILY_INFO, QuotaTableUtil.getSettingsQualifierForUserTable(table));
        }
        for (String ns : namespaces) {
            get2.addColumn(QUOTA_FAMILY_INFO, QuotaTableUtil.getSettingsQualifierForUserNamespace(ns));
        }
        return get2;
    }

    public static Scan makeScan(QuotaFilter filter) {
        Scan scan = new Scan();
        scan.addFamily(QUOTA_FAMILY_INFO);
        if (filter != null && !filter.isNull()) {
            scan.setFilter(QuotaTableUtil.makeFilter(filter));
        }
        return scan;
    }

    public static Filter makeFilter(QuotaFilter filter) {
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        if (!Strings.isEmpty(filter.getUserFilter())) {
            FilterList userFilters = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            boolean hasFilter = false;
            if (!Strings.isEmpty(filter.getNamespaceFilter())) {
                FilterList nsFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                nsFilters.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
                nsFilters.addFilter(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getSettingsQualifierRegexForUserNamespace(filter.getNamespaceFilter()), 0)));
                userFilters.addFilter(nsFilters);
                hasFilter = true;
            }
            if (!Strings.isEmpty(filter.getTableFilter())) {
                FilterList tableFilters = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                tableFilters.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
                tableFilters.addFilter(new QualifierFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getSettingsQualifierRegexForUserTable(filter.getTableFilter()), 0)));
                userFilters.addFilter(tableFilters);
                hasFilter = true;
            }
            if (!hasFilter) {
                userFilters.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getUserRowKeyRegex(filter.getUserFilter()), 0)));
            }
            filterList.addFilter(userFilters);
        } else if (!Strings.isEmpty(filter.getTableFilter())) {
            filterList.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getTableRowKeyRegex(filter.getTableFilter()), 0)));
        } else if (!Strings.isEmpty(filter.getNamespaceFilter())) {
            filterList.addFilter(new RowFilter(CompareFilter.CompareOp.EQUAL, new RegexStringComparator(QuotaTableUtil.getNamespaceRowKeyRegex(filter.getNamespaceFilter()), 0)));
        }
        return filterList;
    }

    public static void parseResult(Result result, QuotasVisitor visitor) throws IOException {
        byte[] row = result.getRow();
        if (QuotaTableUtil.isNamespaceRowKey(row)) {
            QuotaTableUtil.parseNamespaceResult(result, visitor);
        } else if (QuotaTableUtil.isTableRowKey(row)) {
            QuotaTableUtil.parseTableResult(result, visitor);
        } else if (QuotaTableUtil.isUserRowKey(row)) {
            QuotaTableUtil.parseUserResult(result, visitor);
        } else {
            LOG.warn((Object)("unexpected row-key: " + Bytes.toString(row)));
        }
    }

    public static void parseNamespaceResult(Result result, NamespaceQuotasVisitor visitor) throws IOException {
        String namespace = QuotaTableUtil.getNamespaceFromRowKey(result.getRow());
        QuotaTableUtil.parseNamespaceResult(namespace, result, visitor);
    }

    protected static void parseNamespaceResult(String namespace, Result result, NamespaceQuotasVisitor visitor) throws IOException {
        byte[] data = result.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        if (data != null) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData(data);
            visitor.visitNamespaceQuotas(namespace, quotas);
        }
    }

    public static void parseTableResult(Result result, TableQuotasVisitor visitor) throws IOException {
        TableName table = QuotaTableUtil.getTableFromRowKey(result.getRow());
        QuotaTableUtil.parseTableResult(table, result, visitor);
    }

    protected static void parseTableResult(TableName table, Result result, TableQuotasVisitor visitor) throws IOException {
        byte[] data = result.getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
        if (data != null) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData(data);
            visitor.visitTableQuotas(table, quotas);
        }
    }

    public static void parseUserResult(Result result, UserQuotasVisitor visitor) throws IOException {
        String userName = QuotaTableUtil.getUserFromRowKey(result.getRow());
        QuotaTableUtil.parseUserResult(userName, result, visitor);
    }

    protected static void parseUserResult(String userName, Result result, UserQuotasVisitor visitor) throws IOException {
        NavigableMap<byte[], byte[]> familyMap = result.getFamilyMap(QUOTA_FAMILY_INFO);
        if (familyMap == null || familyMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : familyMap.entrySet()) {
            QuotaProtos.Quotas quotas = QuotaTableUtil.quotasFromData((byte[])entry.getValue());
            if (Bytes.startsWith((byte[])entry.getKey(), QUOTA_QUALIFIER_SETTINGS_PREFIX)) {
                String name = Bytes.toString((byte[])entry.getKey(), QUOTA_QUALIFIER_SETTINGS_PREFIX.length);
                if (name.charAt(name.length() - 1) == ':') {
                    String namespace = name.substring(0, name.length() - 1);
                    visitor.visitUserQuotas(userName, namespace, quotas);
                    continue;
                }
                TableName table = TableName.valueOf(name);
                visitor.visitUserQuotas(userName, table, quotas);
                continue;
            }
            if (!Bytes.equals((byte[])entry.getKey(), QUOTA_QUALIFIER_SETTINGS)) continue;
            visitor.visitUserQuotas(userName, quotas);
        }
    }

    protected static QuotaProtos.Quotas quotasFromData(byte[] data) throws IOException {
        int magicLen = ProtobufUtil.lengthOfPBMagic();
        if (!ProtobufUtil.isPBMagicPrefix(data, 0, magicLen)) {
            throw new IOException("Missing pb magic prefix");
        }
        return QuotaProtos.Quotas.parseFrom(new ByteArrayInputStream(data, magicLen, data.length - magicLen));
    }

    protected static byte[] quotasToData(QuotaProtos.Quotas data) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(ProtobufUtil.PB_MAGIC);
        data.writeTo(stream);
        return stream.toByteArray();
    }

    public static boolean isEmptyQuota(QuotaProtos.Quotas quotas) {
        boolean hasSettings = false;
        hasSettings |= quotas.hasThrottle();
        return !(hasSettings |= quotas.hasBypassGlobals());
    }

    protected static Result doGet(Connection connection, Get get2) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            Result result = table.get(get2);
            return result;
        }
    }

    protected static Result[] doGet(Connection connection, List<Get> gets) throws IOException {
        try (Table table = connection.getTable(QUOTA_TABLE_NAME);){
            Result[] resultArray = table.get(gets);
            return resultArray;
        }
    }

    protected static byte[] getUserRowKey(String user) {
        return Bytes.add(QUOTA_USER_ROW_KEY_PREFIX, Bytes.toBytes(user));
    }

    protected static byte[] getTableRowKey(TableName table) {
        return Bytes.add(QUOTA_TABLE_ROW_KEY_PREFIX, table.getName());
    }

    protected static byte[] getNamespaceRowKey(String namespace) {
        return Bytes.add(QUOTA_NAMESPACE_ROW_KEY_PREFIX, Bytes.toBytes(namespace));
    }

    protected static byte[] getSettingsQualifierForUserTable(TableName tableName) {
        return Bytes.add(QUOTA_QUALIFIER_SETTINGS_PREFIX, tableName.getName());
    }

    protected static byte[] getSettingsQualifierForUserNamespace(String namespace) {
        return Bytes.add(QUOTA_QUALIFIER_SETTINGS_PREFIX, Bytes.toBytes(namespace + ':'));
    }

    protected static String getUserRowKeyRegex(String user) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_USER_ROW_KEY_PREFIX, user);
    }

    protected static String getTableRowKeyRegex(String table) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_TABLE_ROW_KEY_PREFIX, table);
    }

    protected static String getNamespaceRowKeyRegex(String namespace) {
        return QuotaTableUtil.getRowKeyRegEx(QUOTA_NAMESPACE_ROW_KEY_PREFIX, namespace);
    }

    private static String getRowKeyRegEx(byte[] prefix, String regex) {
        return '^' + Pattern.quote(Bytes.toString(prefix)) + regex + '$';
    }

    protected static String getSettingsQualifierRegexForUserTable(String table) {
        return '^' + Pattern.quote(Bytes.toString(QUOTA_QUALIFIER_SETTINGS_PREFIX)) + table + "(?<!" + Pattern.quote(Character.toString(':')) + ")$";
    }

    protected static String getSettingsQualifierRegexForUserNamespace(String namespace) {
        return '^' + Pattern.quote(Bytes.toString(QUOTA_QUALIFIER_SETTINGS_PREFIX)) + namespace + Pattern.quote(Character.toString(':')) + '$';
    }

    protected static boolean isNamespaceRowKey(byte[] key) {
        return Bytes.startsWith(key, QUOTA_NAMESPACE_ROW_KEY_PREFIX);
    }

    protected static String getNamespaceFromRowKey(byte[] key) {
        return Bytes.toString(key, QUOTA_NAMESPACE_ROW_KEY_PREFIX.length);
    }

    protected static boolean isTableRowKey(byte[] key) {
        return Bytes.startsWith(key, QUOTA_TABLE_ROW_KEY_PREFIX);
    }

    protected static TableName getTableFromRowKey(byte[] key) {
        return TableName.valueOf(Bytes.toString(key, QUOTA_TABLE_ROW_KEY_PREFIX.length));
    }

    protected static boolean isUserRowKey(byte[] key) {
        return Bytes.startsWith(key, QUOTA_USER_ROW_KEY_PREFIX);
    }

    protected static String getUserFromRowKey(byte[] key) {
        return Bytes.toString(key, QUOTA_USER_ROW_KEY_PREFIX.length);
    }

    public static interface QuotasVisitor
    extends UserQuotasVisitor,
    TableQuotasVisitor,
    NamespaceQuotasVisitor {
    }

    public static interface NamespaceQuotasVisitor {
        public void visitNamespaceQuotas(String var1, QuotaProtos.Quotas var2) throws IOException;
    }

    public static interface TableQuotasVisitor {
        public void visitTableQuotas(TableName var1, QuotaProtos.Quotas var2) throws IOException;
    }

    public static interface UserQuotasVisitor {
        public void visitUserQuotas(String var1, QuotaProtos.Quotas var2) throws IOException;

        public void visitUserQuotas(String var1, TableName var2, QuotaProtos.Quotas var3) throws IOException;

        public void visitUserQuotas(String var1, String var2, QuotaProtos.Quotas var3) throws IOException;
    }
}

