/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ReplaceArchivalHelper
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(ReplaceArchivalHelper.class);

    public static org.apache.hudi.avro.model.HoodieReplaceCommitMetadata convertReplaceCommitMetadata(HoodieReplaceCommitMetadata hoodieReplaceCommitMetadata) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        org.apache.hudi.avro.model.HoodieReplaceCommitMetadata avroMetaData = mapper.convertValue((Object)hoodieReplaceCommitMetadata, org.apache.hudi.avro.model.HoodieReplaceCommitMetadata.class);
        avroMetaData.getExtraMetadata().put("ROLLING_STAT", "");
        return avroMetaData;
    }

    public static boolean deleteReplacedFileGroups(HoodieEngineContext context, HoodieTableMetaClient metaClient, TableFileSystemView fileSystemView, HoodieInstant instant, List<String> replacedPartitions) {
        context.setJobStatus(ReplaceArchivalHelper.class.getSimpleName(), "Delete replaced file groups");
        List<Boolean> f = context.map(replacedPartitions, partition -> {
            Stream fileSlices = fileSystemView.getReplacedFileGroupsBeforeOrOn(instant.getTimestamp(), (String)partition).flatMap(HoodieFileGroup::getAllRawFileSlices);
            return fileSlices.allMatch(slice -> ReplaceArchivalHelper.deleteFileSlice(slice, metaClient, instant));
        }, replacedPartitions.size());
        return f.stream().reduce((x, y) -> x & y).orElse(true);
    }

    private static boolean deleteFileSlice(FileSlice fileSlice, HoodieTableMetaClient metaClient, HoodieInstant instant) {
        boolean baseFileDeleteSuccess = fileSlice.getBaseFile().map(baseFile -> ReplaceArchivalHelper.deletePath(new Path(baseFile.getPath()), metaClient, instant)).orElse(true);
        boolean logFileSuccess = fileSlice.getLogFiles().map(logFile -> ReplaceArchivalHelper.deletePath(logFile.getPath(), metaClient, instant)).allMatch(x -> x);
        return baseFileDeleteSuccess & logFileSuccess;
    }

    private static boolean deletePath(Path path, HoodieTableMetaClient metaClient, HoodieInstant instant) {
        try {
            LOG.info((Object)("Deleting " + path + " before archiving " + instant));
            metaClient.getFs().delete(path);
            return true;
        }
        catch (IOException e) {
            LOG.error((Object)"unable to delete file groups that are replaced", (Throwable)e);
            return false;
        }
    }
}

