/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.DefaultHoodieConfig;

@Immutable
public final class HoodieMetadataConfig
extends DefaultHoodieConfig {
    public static final String METADATA_PREFIX = "hoodie.metadata";
    public static final String METADATA_ENABLE_PROP = "hoodie.metadata.enable";
    public static final boolean DEFAULT_METADATA_ENABLE = false;
    public static final String METADATA_VALIDATE_PROP = "hoodie.metadata.validate";
    public static final boolean DEFAULT_METADATA_VALIDATE = false;
    public static final boolean DEFAULT_METADATA_ENABLE_FOR_READERS = false;
    public static final String METADATA_METRICS_ENABLE_PROP = "hoodie.metadata.metrics.enable";
    public static final boolean DEFAULT_METADATA_METRICS_ENABLE = false;
    public static final String METADATA_INSERT_PARALLELISM_PROP = "hoodie.metadata.insert.parallelism";
    public static final int DEFAULT_METADATA_INSERT_PARALLELISM = 1;
    public static final String METADATA_ASYNC_CLEAN_PROP = "hoodie.metadata.clean.async";
    public static final boolean DEFAULT_METADATA_ASYNC_CLEAN = false;
    public static final String METADATA_COMPACT_NUM_DELTA_COMMITS_PROP = "hoodie.metadata.compact.max.delta.commits";
    public static final int DEFAULT_METADATA_COMPACT_NUM_DELTA_COMMITS = 24;
    public static final String MIN_COMMITS_TO_KEEP_PROP = "hoodie.metadata.keep.min.commits";
    public static final int DEFAULT_MIN_COMMITS_TO_KEEP = 20;
    public static final String MAX_COMMITS_TO_KEEP_PROP = "hoodie.metadata.keep.max.commits";
    public static final int DEFAULT_MAX_COMMITS_TO_KEEP = 30;
    public static final String CLEANER_COMMITS_RETAINED_PROP = "hoodie.metadata.cleaner.commits.retained";
    public static final int DEFAULT_CLEANER_COMMITS_RETAINED = 3;
    public static final String ENABLE_REUSE_PROP = "hoodie.metadata.reuse.enable";
    public static final String DEFAULT_ENABLE_REUSE = "true";
    public static final String ENABLE_FALLBACK_PROP = "hoodie.metadata.fallback.enable";
    public static final String DEFAULT_ENABLE_FALLBACK = "true";
    public static final String HOODIE_ASSUME_DATE_PARTITIONING_PROP = "hoodie.assume.date.partitioning";
    public static final String DEFAULT_ASSUME_DATE_PARTITIONING = "false";
    public static final String FILE_LISTING_PARALLELISM_PROP = "hoodie.file.listing.parallelism";
    public static final int DEFAULT_FILE_LISTING_PARALLELISM = 1500;

    private HoodieMetadataConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getFileListingParallelism() {
        return Math.max(Integer.parseInt(this.props.getProperty(FILE_LISTING_PARALLELISM_PROP)), 1);
    }

    public Boolean shouldAssumeDatePartitioning() {
        return Boolean.parseBoolean(this.props.getProperty(HOODIE_ASSUME_DATE_PARTITIONING_PROP));
    }

    public boolean useFileListingMetadata() {
        return Boolean.parseBoolean(this.props.getProperty(METADATA_ENABLE_PROP));
    }

    public boolean enableReuse() {
        return Boolean.parseBoolean(this.props.getProperty(ENABLE_REUSE_PROP));
    }

    public boolean enableFallback() {
        return Boolean.parseBoolean(this.props.getProperty(ENABLE_FALLBACK_PROP));
    }

    public boolean validateFileListingMetadata() {
        return Boolean.parseBoolean(this.props.getProperty(METADATA_VALIDATE_PROP));
    }

    public boolean enableMetrics() {
        return Boolean.parseBoolean(this.props.getProperty(METADATA_METRICS_ENABLE_PROP));
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder enable(boolean enable) {
            this.props.setProperty(HoodieMetadataConfig.METADATA_ENABLE_PROP, String.valueOf(enable));
            return this;
        }

        public Builder enableMetrics(boolean enableMetrics) {
            this.props.setProperty(HoodieMetadataConfig.METADATA_METRICS_ENABLE_PROP, String.valueOf(enableMetrics));
            return this;
        }

        public Builder enableReuse(boolean reuse) {
            this.props.setProperty(HoodieMetadataConfig.ENABLE_REUSE_PROP, String.valueOf(reuse));
            return this;
        }

        public Builder enableFallback(boolean fallback) {
            this.props.setProperty(HoodieMetadataConfig.ENABLE_FALLBACK_PROP, String.valueOf(fallback));
            return this;
        }

        public Builder validate(boolean validate) {
            this.props.setProperty(HoodieMetadataConfig.METADATA_VALIDATE_PROP, String.valueOf(validate));
            return this;
        }

        public Builder withInsertParallelism(int parallelism) {
            this.props.setProperty(HoodieMetadataConfig.METADATA_INSERT_PARALLELISM_PROP, String.valueOf(parallelism));
            return this;
        }

        public Builder withAsyncClean(boolean asyncClean) {
            this.props.setProperty(HoodieMetadataConfig.METADATA_ASYNC_CLEAN_PROP, String.valueOf(asyncClean));
            return this;
        }

        public Builder withMaxNumDeltaCommitsBeforeCompaction(int maxNumDeltaCommitsBeforeCompaction) {
            this.props.setProperty(HoodieMetadataConfig.METADATA_COMPACT_NUM_DELTA_COMMITS_PROP, String.valueOf(maxNumDeltaCommitsBeforeCompaction));
            return this;
        }

        public Builder archiveCommitsWith(int minToKeep, int maxToKeep) {
            this.props.setProperty(HoodieMetadataConfig.MIN_COMMITS_TO_KEEP_PROP, String.valueOf(minToKeep));
            this.props.setProperty(HoodieMetadataConfig.MAX_COMMITS_TO_KEEP_PROP, String.valueOf(maxToKeep));
            return this;
        }

        public Builder retainCommits(int commitsRetained) {
            this.props.setProperty(HoodieMetadataConfig.CLEANER_COMMITS_RETAINED_PROP, String.valueOf(commitsRetained));
            return this;
        }

        public Builder withFileListingParallelism(int parallelism) {
            this.props.setProperty(HoodieMetadataConfig.FILE_LISTING_PARALLELISM_PROP, String.valueOf(parallelism));
            return this;
        }

        public Builder withAssumeDatePartitioning(boolean assumeDatePartitioning) {
            this.props.setProperty(HoodieMetadataConfig.HOODIE_ASSUME_DATE_PARTITIONING_PROP, String.valueOf(assumeDatePartitioning));
            return this;
        }

        public HoodieMetadataConfig build() {
            HoodieMetadataConfig config = new HoodieMetadataConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.METADATA_ENABLE_PROP), HoodieMetadataConfig.METADATA_ENABLE_PROP, String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.METADATA_METRICS_ENABLE_PROP), HoodieMetadataConfig.METADATA_METRICS_ENABLE_PROP, String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.METADATA_VALIDATE_PROP), HoodieMetadataConfig.METADATA_VALIDATE_PROP, String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.METADATA_INSERT_PARALLELISM_PROP), HoodieMetadataConfig.METADATA_INSERT_PARALLELISM_PROP, String.valueOf(1));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.METADATA_ASYNC_CLEAN_PROP), HoodieMetadataConfig.METADATA_ASYNC_CLEAN_PROP, String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.METADATA_COMPACT_NUM_DELTA_COMMITS_PROP), HoodieMetadataConfig.METADATA_COMPACT_NUM_DELTA_COMMITS_PROP, String.valueOf(24));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.CLEANER_COMMITS_RETAINED_PROP), HoodieMetadataConfig.CLEANER_COMMITS_RETAINED_PROP, String.valueOf(3));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.MAX_COMMITS_TO_KEEP_PROP), HoodieMetadataConfig.MAX_COMMITS_TO_KEEP_PROP, String.valueOf(30));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.MIN_COMMITS_TO_KEEP_PROP), HoodieMetadataConfig.MIN_COMMITS_TO_KEEP_PROP, String.valueOf(20));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.FILE_LISTING_PARALLELISM_PROP), HoodieMetadataConfig.FILE_LISTING_PARALLELISM_PROP, String.valueOf(1500));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.HOODIE_ASSUME_DATE_PARTITIONING_PROP), HoodieMetadataConfig.HOODIE_ASSUME_DATE_PARTITIONING_PROP, HoodieMetadataConfig.DEFAULT_ASSUME_DATE_PARTITIONING);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.ENABLE_FALLBACK_PROP), HoodieMetadataConfig.ENABLE_FALLBACK_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetadataConfig.ENABLE_REUSE_PROP), HoodieMetadataConfig.ENABLE_REUSE_PROP, "true");
            return config;
        }
    }
}

