/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;

public abstract class HoodieEngineContext {
    private SerializableConfiguration hadoopConf;
    protected TaskContextSupplier taskContextSupplier;

    public HoodieEngineContext(SerializableConfiguration hadoopConf, TaskContextSupplier taskContextSupplier) {
        this.hadoopConf = hadoopConf;
        this.taskContextSupplier = taskContextSupplier;
    }

    public SerializableConfiguration getHadoopConf() {
        return this.hadoopConf;
    }

    public TaskContextSupplier getTaskContextSupplier() {
        return this.taskContextSupplier;
    }

    public abstract <I, O> List<O> map(List<I> var1, SerializableFunction<I, O> var2, int var3);

    public abstract <I, O> List<O> flatMap(List<I> var1, SerializableFunction<I, Stream<O>> var2, int var3);

    public abstract <I> void foreach(List<I> var1, SerializableConsumer<I> var2, int var3);

    public abstract <I, K, V> Map<K, V> mapToPair(List<I> var1, SerializablePairFunction<I, K, V> var2, Integer var3);

    public abstract void setProperty(EngineProperty var1, String var2);

    public abstract Option<String> getProperty(EngineProperty var1);

    public abstract void setJobStatus(String var1, String var2);
}

