/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;

public abstract class HoodieLogBlock {
    public static int version = 1;
    private final Map<HeaderMetadataType, String> logBlockHeader;
    private final Map<HeaderMetadataType, String> logBlockFooter;
    private final Option<HoodieLogBlockContentLocation> blockContentLocation;
    private Option<byte[]> content;
    protected FSDataInputStream inputStream;
    protected boolean readBlockLazily;

    public HoodieLogBlock(@Nonnull Map<HeaderMetadataType, String> logBlockHeader, @Nonnull Map<HeaderMetadataType, String> logBlockFooter, @Nonnull Option<HoodieLogBlockContentLocation> blockContentLocation, @Nonnull Option<byte[]> content, FSDataInputStream inputStream, boolean readBlockLazily) {
        this.logBlockHeader = logBlockHeader;
        this.logBlockFooter = logBlockFooter;
        this.blockContentLocation = blockContentLocation;
        this.content = content;
        this.inputStream = inputStream;
        this.readBlockLazily = readBlockLazily;
    }

    public byte[] getContentBytes() throws IOException {
        throw new HoodieException("No implementation was provided");
    }

    public byte[] getMagic() {
        throw new HoodieException("No implementation was provided");
    }

    public abstract HoodieLogBlockType getBlockType();

    public long getLogBlockLength() {
        throw new HoodieException("No implementation was provided");
    }

    public Option<HoodieLogBlockContentLocation> getBlockContentLocation() {
        return this.blockContentLocation;
    }

    public Map<HeaderMetadataType, String> getLogBlockHeader() {
        return this.logBlockHeader;
    }

    public Map<HeaderMetadataType, String> getLogBlockFooter() {
        return this.logBlockFooter;
    }

    public Option<byte[]> getContent() {
        return this.content;
    }

    public static byte[] getLogMetadataBytes(Map<HeaderMetadataType, String> metadata) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        output.writeInt(metadata.size());
        for (Map.Entry<HeaderMetadataType, String> entry : metadata.entrySet()) {
            output.writeInt(entry.getKey().ordinal());
            byte[] bytes = entry.getValue().getBytes();
            output.writeInt(bytes.length);
            output.write(bytes);
        }
        return baos.toByteArray();
    }

    public static Map<HeaderMetadataType, String> getLogMetadata(DataInputStream dis) throws IOException {
        HashMap<HeaderMetadataType, String> metadata = new HashMap<HeaderMetadataType, String>();
        try {
            for (int metadataCount = dis.readInt(); metadataCount > 0; --metadataCount) {
                int metadataEntryIndex = dis.readInt();
                int metadataEntrySize = dis.readInt();
                byte[] metadataEntry = new byte[metadataEntrySize];
                dis.readFully(metadataEntry, 0, metadataEntrySize);
                metadata.put(HeaderMetadataType.values()[metadataEntryIndex], new String(metadataEntry));
            }
            return metadata;
        }
        catch (EOFException eof) {
            throw new IOException("Could not read metadata fields ", eof);
        }
    }

    public static byte[] readOrSkipContent(FSDataInputStream inputStream, Integer contentLength, boolean readBlockLazily) throws IOException {
        byte[] content = null;
        if (!readBlockLazily) {
            content = new byte[contentLength.intValue()];
            inputStream.readFully(content, 0, contentLength.intValue());
        } else {
            HoodieLogBlock.safeSeek(inputStream, inputStream.getPos() + (long)contentLength.intValue());
        }
        return content;
    }

    protected void inflate() throws HoodieIOException {
        try {
            this.content = Option.of(new byte[(int)this.getBlockContentLocation().get().getBlockSize()]);
            HoodieLogBlock.safeSeek(this.inputStream, this.getBlockContentLocation().get().getContentPositionInLogFile());
            this.inputStream.readFully(this.content.get(), 0, this.content.get().length);
            HoodieLogBlock.safeSeek(this.inputStream, this.getBlockContentLocation().get().getBlockEndPos());
        }
        catch (IOException e) {
            this.inflate();
        }
    }

    protected void deflate() {
        this.content = Option.empty();
    }

    private static void safeSeek(FSDataInputStream inputStream, long pos) throws IOException {
        try {
            inputStream.seek(pos);
        }
        catch (EOFException e) {
            if (FSUtils.isGCSInputStream(inputStream)) {
                inputStream.seek(pos - 1L);
            }
            throw e;
        }
    }

    public static final class HoodieLogBlockContentLocation {
        private final HoodieLogFile logFile;
        private final long contentPositionInLogFile;
        private final long blockSize;
        private final long blockEndPos;

        HoodieLogBlockContentLocation(HoodieLogFile logFile, long contentPositionInLogFile, long blockSize, long blockEndPos) {
            this.logFile = logFile;
            this.contentPositionInLogFile = contentPositionInLogFile;
            this.blockSize = blockSize;
            this.blockEndPos = blockEndPos;
        }

        public HoodieLogFile getLogFile() {
            return this.logFile;
        }

        public long getContentPositionInLogFile() {
            return this.contentPositionInLogFile;
        }

        public long getBlockSize() {
            return this.blockSize;
        }

        public long getBlockEndPos() {
            return this.blockEndPos;
        }
    }

    public static enum FooterMetadataType {

    }

    public static enum HeaderMetadataType {
        INSTANT_TIME,
        TARGET_INSTANT_TIME,
        SCHEMA,
        COMMAND_BLOCK_TYPE;

    }

    public static enum HoodieLogBlockType {
        COMMAND_BLOCK,
        DELETE_BLOCK,
        CORRUPT_BLOCK,
        AVRO_DATA_BLOCK,
        HFILE_DATA_BLOCK;

    }
}

