/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.DefaultHoodieConfig;
import org.apache.hudi.config.HoodieMetricsDatadogConfig;
import org.apache.hudi.config.HoodieMetricsPrometheusConfig;
import org.apache.hudi.metrics.MetricsReporterType;

@Immutable
public class HoodieMetricsConfig
extends DefaultHoodieConfig {
    public static final String METRIC_PREFIX = "hoodie.metrics";
    public static final String METRICS_ON = "hoodie.metrics.on";
    public static final boolean DEFAULT_METRICS_ON = false;
    public static final String METRICS_REPORTER_TYPE = "hoodie.metrics.reporter.type";
    public static final MetricsReporterType DEFAULT_METRICS_REPORTER_TYPE = MetricsReporterType.GRAPHITE;
    public static final String GRAPHITE_PREFIX = "hoodie.metrics.graphite";
    public static final String GRAPHITE_SERVER_HOST = "hoodie.metrics.graphite.host";
    public static final String DEFAULT_GRAPHITE_SERVER_HOST = "localhost";
    public static final String GRAPHITE_SERVER_PORT = "hoodie.metrics.graphite.port";
    public static final int DEFAULT_GRAPHITE_SERVER_PORT = 4756;
    public static final String JMX_PREFIX = "hoodie.metrics.jmx";
    public static final String JMX_HOST = "hoodie.metrics.jmx.host";
    public static final String DEFAULT_JMX_HOST = "localhost";
    public static final String JMX_PORT = "hoodie.metrics.jmx.port";
    public static final int DEFAULT_JMX_PORT = 9889;
    public static final String GRAPHITE_METRIC_PREFIX = "hoodie.metrics.graphite.metric.prefix";
    public static final String METRICS_REPORTER_CLASS = "hoodie.metrics.reporter.class";
    public static final String DEFAULT_METRICS_REPORTER_CLASS = "";
    public static final String ENABLE_EXECUTOR_METRICS = "hoodie.metrics.executor.enable";

    private HoodieMetricsConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder on(boolean metricsOn) {
            this.props.setProperty(HoodieMetricsConfig.METRICS_ON, String.valueOf(metricsOn));
            return this;
        }

        public Builder withReporterType(String reporterType) {
            this.props.setProperty(HoodieMetricsConfig.METRICS_REPORTER_TYPE, reporterType);
            return this;
        }

        public Builder toGraphiteHost(String host) {
            this.props.setProperty(HoodieMetricsConfig.GRAPHITE_SERVER_HOST, host);
            return this;
        }

        public Builder onGraphitePort(int port) {
            this.props.setProperty(HoodieMetricsConfig.GRAPHITE_SERVER_PORT, String.valueOf(port));
            return this;
        }

        public Builder toJmxHost(String host) {
            this.props.setProperty(HoodieMetricsConfig.JMX_HOST, host);
            return this;
        }

        public Builder onJmxPort(String port) {
            this.props.setProperty(HoodieMetricsConfig.JMX_PORT, port);
            return this;
        }

        public Builder usePrefix(String prefix) {
            this.props.setProperty(HoodieMetricsConfig.GRAPHITE_METRIC_PREFIX, prefix);
            return this;
        }

        public Builder withReporterClass(String className) {
            this.props.setProperty(HoodieMetricsConfig.METRICS_REPORTER_CLASS, className);
            return this;
        }

        public Builder withExecutorMetrics(boolean enable) {
            this.props.setProperty(HoodieMetricsConfig.ENABLE_EXECUTOR_METRICS, String.valueOf(enable));
            return this;
        }

        public HoodieMetricsConfig build() {
            HoodieMetricsConfig config = new HoodieMetricsConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetricsConfig.METRICS_ON), HoodieMetricsConfig.METRICS_ON, String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetricsConfig.METRICS_REPORTER_TYPE), HoodieMetricsConfig.METRICS_REPORTER_TYPE, DEFAULT_METRICS_REPORTER_TYPE.name());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetricsConfig.GRAPHITE_SERVER_HOST), HoodieMetricsConfig.GRAPHITE_SERVER_HOST, "localhost");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetricsConfig.GRAPHITE_SERVER_PORT), HoodieMetricsConfig.GRAPHITE_SERVER_PORT, String.valueOf(4756));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetricsConfig.JMX_HOST), HoodieMetricsConfig.JMX_HOST, "localhost");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetricsConfig.JMX_PORT), HoodieMetricsConfig.JMX_PORT, String.valueOf(9889));
            MetricsReporterType reporterType = MetricsReporterType.valueOf(this.props.getProperty(HoodieMetricsConfig.METRICS_REPORTER_TYPE));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, reporterType == MetricsReporterType.DATADOG, HoodieMetricsDatadogConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMetricsConfig.METRICS_REPORTER_CLASS), HoodieMetricsConfig.METRICS_REPORTER_CLASS, HoodieMetricsConfig.DEFAULT_METRICS_REPORTER_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, reporterType == MetricsReporterType.PROMETHEUS_PUSHGATEWAY, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, reporterType == MetricsReporterType.PROMETHEUS, HoodieMetricsPrometheusConfig.newBuilder().fromProperties(this.props).build());
            return config;
        }
    }
}

