/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.util.List;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.state.FlinkInMemoryStateIndex;
import org.apache.hudi.table.HoodieTable;

public abstract class FlinkHoodieIndex<T extends HoodieRecordPayload>
extends HoodieIndex<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    protected FlinkHoodieIndex(HoodieWriteConfig config) {
        super(config);
    }

    public static FlinkHoodieIndex createIndex(HoodieFlinkEngineContext context, HoodieWriteConfig config) {
        if (!StringUtils.isNullOrEmpty(config.getIndexClass())) {
            Object instance = ReflectionUtils.loadClass(config.getIndexClass(), config);
            if (!(instance instanceof HoodieIndex)) {
                throw new HoodieIndexException(config.getIndexClass() + " is not a subclass of HoodieIndex");
            }
            return (FlinkHoodieIndex)instance;
        }
        switch (config.getIndexType()) {
            case INMEMORY: {
                return new FlinkInMemoryStateIndex(context, config);
            }
        }
        throw new HoodieIndexException("Unsupported index type " + (Object)((Object)config.getIndexType()));
    }

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public abstract List<WriteStatus> updateLocation(List<WriteStatus> var1, HoodieEngineContext var2, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> var3) throws HoodieIndexException;

    @Override
    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public abstract List<HoodieRecord<T>> tagLocation(List<HoodieRecord<T>> var1, HoodieEngineContext var2, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> var3) throws HoodieIndexException;
}

