/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.table.HoodieTable;

public class HoodieKeyLocationFetchHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieReadHandle<T, I, K, O> {
    private final Pair<String, HoodieBaseFile> partitionPathBaseFilePair;

    public HoodieKeyLocationFetchHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, HoodieBaseFile> partitionPathBaseFilePair) {
        super(config, null, hoodieTable, Pair.of(partitionPathBaseFilePair.getLeft(), partitionPathBaseFilePair.getRight().getFileId()));
        this.partitionPathBaseFilePair = partitionPathBaseFilePair;
    }

    public Stream<Pair<HoodieKey, HoodieRecordLocation>> locations() {
        HoodieBaseFile baseFile = this.partitionPathBaseFilePair.getRight();
        return ParquetUtils.fetchRecordKeyPartitionPathFromParquet(this.hoodieTable.getHadoopConf(), new Path(baseFile.getPath())).stream().map(entry -> Pair.of(entry, new HoodieRecordLocation(baseFile.getCommitTime(), baseFile.getFileId())));
    }
}

