/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieMetadataFileInfo;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.MetadataPartitionType;

public class HoodieMetadataPayload
implements HoodieRecordPayload<HoodieMetadataPayload> {
    private static final int PARTITION_LIST = 1;
    private static final int FILE_LIST = 2;
    private String key = null;
    private int type = 0;
    private Map<String, HoodieMetadataFileInfo> filesystemMetadata = null;

    public HoodieMetadataPayload(Option<GenericRecord> record) {
        if (record.isPresent()) {
            this.key = record.get().get("key").toString();
            this.type = (Integer)record.get().get("type");
            if (record.get().get("filesystemMetadata") != null) {
                this.filesystemMetadata = (Map)record.get().get("filesystemMetadata");
                this.filesystemMetadata.keySet().forEach(k -> {
                    GenericRecord v = this.filesystemMetadata.get(k);
                    this.filesystemMetadata.put(k.toString(), new HoodieMetadataFileInfo((Long)v.get("size"), (Boolean)v.get("isDeleted")));
                });
            }
        }
    }

    private HoodieMetadataPayload(String key, int type, Map<String, HoodieMetadataFileInfo> filesystemMetadata) {
        this.key = key;
        this.type = type;
        this.filesystemMetadata = filesystemMetadata;
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionListRecord(List<String> partitions) {
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        partitions.forEach(partition -> fileInfo.put((String)partition, new HoodieMetadataFileInfo(0L, false)));
        HoodieKey key = new HoodieKey("__all_partitions__", MetadataPartitionType.FILES.partitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), 1, fileInfo);
        return new HoodieRecord<HoodieMetadataPayload>(key, payload);
    }

    public static HoodieRecord<HoodieMetadataPayload> createPartitionFilesRecord(String partition, Option<Map<String, Long>> filesAdded, Option<List<String>> filesDeleted) {
        HashMap<String, HoodieMetadataFileInfo> fileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        filesAdded.ifPresent(m -> m.forEach((filename, size) -> fileInfo.put((String)filename, new HoodieMetadataFileInfo((Long)size, false))));
        filesDeleted.ifPresent(m -> m.forEach(filename -> fileInfo.put((String)filename, new HoodieMetadataFileInfo(0L, true))));
        HoodieKey key = new HoodieKey(partition, MetadataPartitionType.FILES.partitionPath());
        HoodieMetadataPayload payload = new HoodieMetadataPayload(key.getRecordKey(), 2, fileInfo);
        return new HoodieRecord<HoodieMetadataPayload>(key, payload);
    }

    @Override
    public HoodieMetadataPayload preCombine(HoodieMetadataPayload previousRecord) {
        ValidationUtils.checkArgument(previousRecord.type == this.type, "Cannot combine " + previousRecord.type + " with " + this.type);
        Map<String, HoodieMetadataFileInfo> combinedFileInfo = null;
        switch (this.type) {
            case 1: 
            case 2: {
                combinedFileInfo = this.combineFilesystemMetadata(previousRecord);
                break;
            }
            default: {
                throw new HoodieMetadataException("Unknown type of HoodieMetadataPayload: " + this.type);
            }
        }
        return new HoodieMetadataPayload(this.key, this.type, combinedFileInfo);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRecord, Schema schema) throws IOException {
        HoodieMetadataPayload anotherPayload = new HoodieMetadataPayload(Option.of((GenericRecord)oldRecord));
        HoodieMetadataPayload combinedPayload = this.preCombine(anotherPayload);
        return combinedPayload.getInsertValue(schema);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.key == null) {
            return Option.empty();
        }
        HoodieMetadataRecord record = new HoodieMetadataRecord(this.key, this.type, this.filesystemMetadata);
        return Option.of(record);
    }

    public List<String> getFilenames() {
        return this.filterFileInfoEntries(false).map(e -> (String)e.getKey()).sorted().collect(Collectors.toList());
    }

    public List<String> getDeletions() {
        return this.filterFileInfoEntries(true).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public FileStatus[] getFileStatuses(Configuration hadoopConf, Path partitionPath) throws IOException {
        FileSystem fs = partitionPath.getFileSystem(hadoopConf);
        long blockSize = fs.getDefaultBlockSize(partitionPath);
        return (FileStatus[])this.filterFileInfoEntries(false).map(e -> new FileStatus(((HoodieMetadataFileInfo)e.getValue()).getSize().longValue(), false, 0, blockSize, 0L, 0L, null, null, null, new Path(partitionPath, (String)e.getKey()))).toArray(FileStatus[]::new);
    }

    private Stream<Map.Entry<String, HoodieMetadataFileInfo>> filterFileInfoEntries(boolean isDeleted) {
        if (this.filesystemMetadata == null) {
            return Stream.empty();
        }
        return this.filesystemMetadata.entrySet().stream().filter(e -> ((HoodieMetadataFileInfo)e.getValue()).getIsDeleted() == isDeleted);
    }

    private Map<String, HoodieMetadataFileInfo> combineFilesystemMetadata(HoodieMetadataPayload previousRecord) {
        HashMap<String, HoodieMetadataFileInfo> combinedFileInfo = new HashMap<String, HoodieMetadataFileInfo>();
        if (previousRecord.filesystemMetadata != null) {
            combinedFileInfo.putAll(previousRecord.filesystemMetadata);
        }
        if (this.filesystemMetadata != null) {
            this.filesystemMetadata.forEach((filename, fileInfo) -> {
                if (!combinedFileInfo.containsKey(filename)) {
                    combinedFileInfo.put((String)filename, (HoodieMetadataFileInfo)fileInfo);
                } else if (fileInfo.getIsDeleted().booleanValue()) {
                    combinedFileInfo.remove(filename);
                } else {
                    combinedFileInfo.merge((String)filename, (HoodieMetadataFileInfo)fileInfo, (oldFileInfo, newFileInfo) -> new HoodieMetadataFileInfo(oldFileInfo.getSize() + newFileInfo.getSize(), false));
                }
            });
        }
        return combinedFileInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieMetadataPayload {");
        sb.append("key=").append(this.key).append(", ");
        sb.append("type=").append(this.type).append(", ");
        sb.append("creations=").append(Arrays.toString(this.getFilenames().toArray())).append(", ");
        sb.append("deletions=").append(Arrays.toString(this.getDeletions().toArray())).append(", ");
        sb.append('}');
        return sb.toString();
    }
}

