/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.hudi.HoodieFlinkStreamer;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.client.HoodieFlinkWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieFlinkStreamerException;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitSink
extends RichSinkFunction<Tuple3<String, List<WriteStatus>, Integer>> {
    private static final Logger LOG = LoggerFactory.getLogger(CommitSink.class);
    private HoodieFlinkStreamer.Config cfg;
    private transient HoodieFlinkWriteClient writeClient;
    private Map<String, List<List<WriteStatus>>> bufferedWriteStatus = new HashMap<String, List<List<WriteStatus>>>();
    private Integer writeParallelSize = 0;

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.cfg = (HoodieFlinkStreamer.Config)this.getRuntimeContext().getExecutionConfig().getGlobalJobParameters();
        this.writeParallelSize = this.getRuntimeContext().getExecutionConfig().getParallelism();
        this.writeClient = new HoodieFlinkWriteClient(new HoodieFlinkEngineContext(new FlinkTaskContextSupplier(null)), StreamerUtil.getHoodieClientConfig(this.cfg));
    }

    public void invoke(Tuple3<String, List<WriteStatus>, Integer> writeStatues, SinkFunction.Context context) {
        LOG.info("Receive records, instantTime = [{}], subtaskId = [{}], WriteStatus size = [{}]", new Object[]{writeStatues.f0, writeStatues.f2, ((List)writeStatues.f1).size()});
        try {
            if (this.bufferedWriteStatus.containsKey(writeStatues.f0)) {
                this.bufferedWriteStatus.get(writeStatues.f0).add((List<WriteStatus>)writeStatues.f1);
            } else {
                ArrayList<Object> oneBatchData = new ArrayList<Object>(this.writeParallelSize);
                oneBatchData.add(writeStatues.f1);
                this.bufferedWriteStatus.put((String)writeStatues.f0, oneBatchData);
            }
            this.checkAndCommit((String)writeStatues.f0);
        }
        catch (Exception e) {
            throw new HoodieFlinkStreamerException("Invoke sink error", e);
        }
    }

    private void checkAndCommit(String instantTime) throws Exception {
        if (this.bufferedWriteStatus.get(instantTime).size() == this.writeParallelSize.intValue()) {
            LOG.info("Instant [{}] process complete, start commit\uff01", (Object)instantTime);
            this.doCommit(instantTime);
            this.bufferedWriteStatus.clear();
            LOG.info("Instant [{}] commit completed!", (Object)instantTime);
        } else {
            LOG.info("Instant [{}], can not commit yet, subtask completed : [{}/{}]", new Object[]{instantTime, this.bufferedWriteStatus.get(instantTime).size(), this.writeParallelSize});
        }
    }

    private void doCommit(String instantTime) {
        boolean hasErrors;
        List writeResults = this.bufferedWriteStatus.get(instantTime).stream().flatMap(Collection::stream).collect(Collectors.toList());
        long totalErrorRecords = writeResults.stream().map(WriteStatus::getTotalErrorRecords).reduce(Long::sum).orElse(0L);
        long totalRecords = writeResults.stream().map(WriteStatus::getTotalRecords).reduce(Long::sum).orElse(0L);
        boolean bl = hasErrors = totalErrorRecords > 0L;
        if (!hasErrors || this.cfg.commitOnErrors.booleanValue()) {
            boolean success;
            HashMap checkpointCommitMetadata = new HashMap();
            if (hasErrors) {
                LOG.warn("Some records failed to be merged but forcing commit since commitOnErrors set. Errors/Total=" + totalErrorRecords + "/" + totalRecords);
            }
            if (!(success = this.writeClient.commit(instantTime, writeResults, Option.of(checkpointCommitMetadata)))) {
                LOG.warn("Commit " + instantTime + " failed!");
                throw new HoodieException("Commit " + instantTime + " failed!");
            }
        } else {
            LOG.error("Streamer sync found errors when writing. Errors/Total=" + totalErrorRecords + "/" + totalRecords);
            LOG.error("Printing out the top 100 errors");
            writeResults.stream().filter(WriteStatus::hasErrors).limit(100L).forEach(ws -> {
                LOG.error("Global error :", ws.getGlobalError());
                if (ws.getErrors().size() > 0) {
                    ws.getErrors().forEach((key, value) -> LOG.trace("Error for key:" + key + " is " + value));
                }
            });
            this.writeClient.rollback(instantTime);
            throw new HoodieException("Commit " + instantTime + " failed and rolled-back !");
        }
        LOG.warn("Commit " + instantTime + " successful!");
    }
}

