/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieFlinkStreamerException;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.schema.FilebasedSchemaProvider;
import org.apache.hudi.util.AvroConvertor;
import org.apache.hudi.util.StreamerUtil;

public class JsonStringToHoodieRecordMapFunction
implements MapFunction<String, HoodieRecord> {
    private TypedProperties props;
    private KeyGenerator keyGenerator;
    private AvroConvertor avroConvertor;
    private Option<String> schemaStr;
    private String payloadClassName;
    private String orderingField;

    public JsonStringToHoodieRecordMapFunction(TypedProperties props) {
        this(props, Option.empty());
    }

    public JsonStringToHoodieRecordMapFunction(TypedProperties props, Option<String> schemaStr) {
        this.props = props;
        this.schemaStr = schemaStr;
        this.init();
    }

    public HoodieRecord map(String value) throws Exception {
        GenericRecord gr = this.avroConvertor.fromJson(value);
        HoodieRecordPayload payload = StreamerUtil.createPayload(this.payloadClassName, gr, (Comparable)HoodieAvroUtils.getNestedFieldVal(gr, this.orderingField, false));
        return new HoodieRecord<HoodieRecordPayload>(this.keyGenerator.getKey(gr), payload);
    }

    private void init() {
        this.avroConvertor = this.schemaStr.isPresent() ? new AvroConvertor(new Schema.Parser().parse(this.schemaStr.get())) : new AvroConvertor(new FilebasedSchemaProvider(this.props).getSourceSchema());
        this.payloadClassName = this.props.getString("hoodie.datasource.write.payload.class", OverwriteWithLatestAvroPayload.class.getName());
        this.orderingField = this.props.getString("hoodie.datasource.write.precombine.field", "ts");
        try {
            this.keyGenerator = StreamerUtil.createKeyGenerator(this.props);
        }
        catch (IOException e) {
            throw new HoodieFlinkStreamerException(String.format("KeyGenerator %s initialization failed", this.props.getString("hoodie.datasource.write.keygenerator.class", SimpleAvroKeyGenerator.class.getName())), e);
        }
    }
}

