/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.collection.Pair;

public class WorkloadStat
implements Serializable {
    private long numInserts = 0L;
    private long numUpdates = 0L;
    private HashMap<String, Pair<String, Long>> updateLocationToCount = new HashMap();

    public long addInserts(long numInserts) {
        return this.numInserts += numInserts;
    }

    public long addUpdates(HoodieRecordLocation location, long numUpdates) {
        this.updateLocationToCount.put(location.getFileId(), Pair.of(location.getInstantTime(), numUpdates));
        return this.numUpdates += numUpdates;
    }

    public long getNumUpdates() {
        return this.numUpdates;
    }

    public long getNumInserts() {
        return this.numInserts;
    }

    public HashMap<String, Pair<String, Long>> getUpdateLocationToCount() {
        return this.updateLocationToCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkloadStat {");
        sb.append("numInserts=").append(this.numInserts).append(", ");
        sb.append("numUpdates=").append(this.numUpdates);
        sb.append('}');
        return sb.toString();
    }
}

