/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.table.upgrade.AbstractUpgradeDowngrade;
import org.apache.hudi.table.upgrade.OneToZeroDowngradeHandler;
import org.apache.hudi.table.upgrade.ZeroToOneUpgradeHandler;

public class FlinkUpgradeDowngrade
extends AbstractUpgradeDowngrade {
    public FlinkUpgradeDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieEngineContext context) {
        super(metaClient, config, context);
    }

    @Override
    public void run(HoodieTableMetaClient metaClient, HoodieTableVersion toVersion, HoodieWriteConfig config, HoodieEngineContext context, String instantTime) {
        try {
            new FlinkUpgradeDowngrade(metaClient, config, context).run(toVersion, instantTime);
        }
        catch (IOException e) {
            throw new HoodieUpgradeDowngradeException("Error during upgrade/downgrade to version:" + (Object)((Object)toVersion), e);
        }
    }

    @Override
    protected void upgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion != HoodieTableVersion.ZERO || toVersion != HoodieTableVersion.ONE) {
            throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), true);
        }
        new ZeroToOneUpgradeHandler().upgrade(this.config, this.context, instantTime);
    }

    @Override
    protected void downgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion != HoodieTableVersion.ONE || toVersion != HoodieTableVersion.ZERO) {
            throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), false);
        }
        new OneToZeroDowngradeHandler().downgrade(this.config, this.context, instantTime);
    }
}

