/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ByteBufferInputStream;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestByteBufferInputStream {
    @Test
    public void testReads() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(100);
        DataOutputStream dos = new DataOutputStream(bos);
        String s = "test";
        int i = 128;
        dos.write(1);
        dos.writeInt(i);
        dos.writeBytes(s);
        dos.writeLong(12345L);
        dos.writeShort(2);
        dos.flush();
        ByteBuffer bb = ByteBuffer.wrap(bos.toByteArray());
        ByteBufferInputStream bbis = new ByteBufferInputStream(bb);
        Assert.assertEquals((long)(15 + s.length()), (long)bbis.available());
        Assert.assertEquals((long)1L, (long)bbis.read());
        byte[] ib = new byte[4];
        bbis.read(ib);
        Assert.assertEquals((long)i, (long)Bytes.toInt(ib));
        byte[] sb = new byte[s.length()];
        bbis.read(sb);
        Assert.assertEquals((Object)s, (Object)Bytes.toString(sb));
        byte[] lb = new byte[8];
        bbis.read(lb);
        Assert.assertEquals((long)12345L, (long)Bytes.toLong(lb));
        Assert.assertEquals((long)2L, (long)bbis.available());
        ib = new byte[4];
        int read = bbis.read(ib, 0, ib.length);
        Assert.assertEquals((long)2L, (long)read);
        Assert.assertEquals((long)2L, (long)Bytes.toShort(ib));
        Assert.assertEquals((long)0L, (long)bbis.available());
        Assert.assertEquals((long)-1L, (long)bbis.read());
        bbis.close();
        bb = ByteBuffer.wrap(bos.toByteArray());
        bbis = new ByteBufferInputStream(bb);
        DataInputStream dis = new DataInputStream(bbis);
        dis.read();
        Assert.assertEquals((long)i, (long)dis.readInt());
        dis.close();
    }
}

