/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.visibility.ParseException;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsValidator;
import org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import org.apache.hadoop.hbase.security.visibility.expression.Operator;

@InterfaceAudience.Private
public class ExpressionParser {
    private static final char CLOSE_PARAN = ')';
    private static final char OPEN_PARAN = '(';
    private static final char OR = '|';
    private static final char AND = '&';
    private static final char NOT = '!';
    private static final char SPACE = ' ';
    private static final char DOUBLE_QUOTES = '\"';

    public ExpressionNode parse(String expS) throws ParseException {
        NonLeafExpressionNode nlTop;
        expS = expS.trim();
        Stack<ExpressionNode> expStack = new Stack<ExpressionNode>();
        byte[] exp = org.apache.hadoop.hbase.util.Bytes.toBytes(expS);
        int endPos = exp.length;
        block7: for (int index = 0; index < endPos; ++index) {
            byte b = exp[index];
            switch (b) {
                case 40: {
                    this.processOpenParan(expStack, expS, index);
                    index = this.skipSpaces(exp, index);
                    continue block7;
                }
                case 41: {
                    this.processCloseParan(expStack, expS, index);
                    index = this.skipSpaces(exp, index);
                    continue block7;
                }
                case 38: 
                case 124: {
                    this.processANDorOROp(ExpressionParser.getOperator(b), expStack, expS, index);
                    index = this.skipSpaces(exp, index);
                    continue block7;
                }
                case 33: {
                    this.processNOTOp(expStack, expS, index);
                    continue block7;
                }
                case 34: {
                    int labelOffset = ++index;
                    ArrayList<Byte> list = new ArrayList<Byte>();
                    while (index < endPos && !ExpressionParser.endDoubleQuotesFound(exp[index])) {
                        if (exp[index] == 92 && exp[++index] != 92 && exp[index] != 34) {
                            throw new ParseException("invalid escaping with quotes " + expS + " at column : " + index);
                        }
                        list.add(exp[index]);
                        ++index;
                    }
                    if (index == endPos) {
                        throw new ParseException("No terminating quotes " + expS + " at column : " + index);
                    }
                    byte[] array2 = Bytes.toArray(list);
                    String leafExp = org.apache.hadoop.hbase.util.Bytes.toString(array2).trim();
                    if (leafExp.isEmpty()) {
                        throw new ParseException("Error parsing expression " + expS + " at column : " + index);
                    }
                    this.processLabelExpNode(new LeafExpressionNode(leafExp), expStack, expS, index);
                    index = this.skipSpaces(exp, index);
                    continue block7;
                }
                default: {
                    int labelOffset = index;
                    do {
                        if (VisibilityLabelsValidator.isValidAuthChar(exp[index])) continue;
                        throw new ParseException("Error parsing expression " + expS + " at column : " + index);
                    } while (++index < endPos && !ExpressionParser.isEndOfLabel(exp[index]));
                    String leafExp = new String(exp, labelOffset, index - labelOffset).trim();
                    if (leafExp.isEmpty()) {
                        throw new ParseException("Error parsing expression " + expS + " at column : " + index);
                    }
                    this.processLabelExpNode(new LeafExpressionNode(leafExp), expStack, expS, index);
                    --index;
                    index = this.skipSpaces(exp, index);
                }
            }
        }
        if (expStack.size() != 1) {
            throw new ParseException("Error parsing expression " + expS);
        }
        ExpressionNode top = (ExpressionNode)expStack.pop();
        if (top == LeafExpressionNode.OPEN_PARAN_NODE) {
            throw new ParseException("Error parsing expression " + expS);
        }
        if (top instanceof NonLeafExpressionNode && ((nlTop = (NonLeafExpressionNode)top).getOperator() == Operator.NOT ? nlTop.getChildExps().size() != 1 : nlTop.getChildExps().size() != 2)) {
            throw new ParseException("Error parsing expression " + expS);
        }
        return top;
    }

    private int skipSpaces(byte[] exp, int index) {
        while (index < exp.length - 1 && exp[index + 1] == 32) {
            ++index;
        }
        return index;
    }

    private void processCloseParan(Stack<ExpressionNode> expStack, String expS, int index) throws ParseException {
        ExpressionNode thirdTop;
        NonLeafExpressionNode nlTop;
        if (expStack.size() < 2) {
            throw new ParseException();
        }
        ExpressionNode top = expStack.pop();
        ExpressionNode secondTop = expStack.pop();
        if (top == LeafExpressionNode.OPEN_PARAN_NODE || secondTop != LeafExpressionNode.OPEN_PARAN_NODE) {
            throw new ParseException("Error parsing expression " + expS + " at column : " + index);
        }
        if (top instanceof NonLeafExpressionNode && ((nlTop = (NonLeafExpressionNode)top).getOperator() == Operator.NOT && nlTop.getChildExps().size() != 1 || nlTop.getOperator() != Operator.NOT && nlTop.getChildExps().size() != 2)) {
            throw new ParseException("Error parsing expression " + expS + " at column : " + index);
        }
        if (!expStack.isEmpty() && (thirdTop = expStack.peek()) instanceof NonLeafExpressionNode) {
            ExpressionNode fourthTop;
            NonLeafExpressionNode nlThirdTop = (NonLeafExpressionNode)expStack.pop();
            nlThirdTop.addChildExp(top);
            if (nlThirdTop.getOperator() == Operator.NOT && !expStack.isEmpty() && (fourthTop = expStack.peek()) instanceof NonLeafExpressionNode) {
                NonLeafExpressionNode nlFourthTop = (NonLeafExpressionNode)fourthTop;
                assert (nlFourthTop.getOperator() != Operator.NOT);
                assert (nlFourthTop.getChildExps().size() == 1);
                nlFourthTop.addChildExp(nlThirdTop);
                return;
            }
            top = nlThirdTop;
        }
        expStack.push(top);
    }

    private void processOpenParan(Stack<ExpressionNode> expStack, String expS, int index) throws ParseException {
        if (!expStack.isEmpty()) {
            NonLeafExpressionNode nlTop;
            ExpressionNode top = expStack.peek();
            if (top instanceof LeafExpressionNode && top != LeafExpressionNode.OPEN_PARAN_NODE) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index);
            }
            if (top instanceof NonLeafExpressionNode && ((nlTop = (NonLeafExpressionNode)top).getOperator() == Operator.NOT && nlTop.getChildExps().size() != 0 || nlTop.getOperator() != Operator.NOT && nlTop.getChildExps().size() != 1)) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index);
            }
        }
        expStack.push(LeafExpressionNode.OPEN_PARAN_NODE);
    }

    private void processLabelExpNode(LeafExpressionNode node, Stack<ExpressionNode> expStack, String expS, int index) throws ParseException {
        if (expStack.isEmpty()) {
            expStack.push(node);
        } else {
            ExpressionNode top = expStack.peek();
            if (top == LeafExpressionNode.OPEN_PARAN_NODE) {
                expStack.push(node);
            } else if (top instanceof NonLeafExpressionNode) {
                NonLeafExpressionNode nlTop = (NonLeafExpressionNode)expStack.pop();
                nlTop.addChildExp(node);
                if (nlTop.getOperator() == Operator.NOT && !expStack.isEmpty()) {
                    ExpressionNode secondTop = expStack.peek();
                    if (secondTop == LeafExpressionNode.OPEN_PARAN_NODE) {
                        expStack.push(nlTop);
                    } else if (secondTop instanceof NonLeafExpressionNode) {
                        ((NonLeafExpressionNode)secondTop).addChildExp(nlTop);
                    }
                } else {
                    expStack.push(nlTop);
                }
            } else {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index);
            }
        }
    }

    private void processANDorOROp(Operator op, Stack<ExpressionNode> expStack, String expS, int index) throws ParseException {
        if (expStack.isEmpty()) {
            throw new ParseException("Error parsing expression " + expS + " at column : " + index);
        }
        ExpressionNode top = expStack.pop();
        if (top.isSingleNode()) {
            if (top == LeafExpressionNode.OPEN_PARAN_NODE) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index);
            }
            expStack.push(new NonLeafExpressionNode(op, top));
        } else {
            NonLeafExpressionNode nlTop = (NonLeafExpressionNode)top;
            if (nlTop.getChildExps().size() != 2) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index);
            }
            expStack.push(new NonLeafExpressionNode(op, nlTop));
        }
    }

    private void processNOTOp(Stack<ExpressionNode> expStack, String expS, int index) throws ParseException {
        if (!expStack.isEmpty()) {
            ExpressionNode top = expStack.peek();
            if (top.isSingleNode() && top != LeafExpressionNode.OPEN_PARAN_NODE) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index);
            }
            if (!top.isSingleNode() && ((NonLeafExpressionNode)top).getChildExps().size() != 1) {
                throw new ParseException("Error parsing expression " + expS + " at column : " + index);
            }
        }
        expStack.push(new NonLeafExpressionNode(Operator.NOT));
    }

    private static boolean endDoubleQuotesFound(byte b) {
        return b == 34;
    }

    private static boolean isEndOfLabel(byte b) {
        return b == 40 || b == 41 || b == 124 || b == 38 || b == 33 || b == 32;
    }

    private static Operator getOperator(byte op) {
        switch (op) {
            case 38: {
                return Operator.AND;
            }
            case 124: {
                return Operator.OR;
            }
            case 33: {
                return Operator.NOT;
            }
        }
        return null;
    }
}

