/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.common;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieFlinkEngineContext
extends HoodieEngineContext {
    private RuntimeContext runtimeContext;

    public HoodieFlinkEngineContext(TaskContextSupplier taskContextSupplier) {
        this(new SerializableConfiguration(new Configuration()), taskContextSupplier);
    }

    public HoodieFlinkEngineContext(SerializableConfiguration hadoopConf, TaskContextSupplier taskContextSupplier) {
        super(hadoopConf, taskContextSupplier);
        this.runtimeContext = ((FlinkTaskContextSupplier)taskContextSupplier).getFlinkRuntimeContext();
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public <I, O> List<O> map(List<I> data, SerializableFunction<I, O> func, int parallelism) {
        return ((Stream)data.stream().parallel()).map(FunctionWrapper.throwingMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I, O> List<O> flatMap(List<I> data, SerializableFunction<I, Stream<O>> func, int parallelism) {
        return ((Stream)data.stream().parallel()).flatMap(FunctionWrapper.throwingFlatMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I> void foreach(List<I> data, SerializableConsumer<I> consumer, int parallelism) {
        data.forEach(FunctionWrapper.throwingForeachWrapper(consumer));
    }

    @Override
    public <I, K, V> Map<K, V> mapToPair(List<I> data, SerializablePairFunction<I, K, V> func, Integer parallelism) {
        return data.stream().map(FunctionWrapper.throwingMapToPairWrapper(func)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    @Override
    public void setProperty(EngineProperty key, String value) {
    }

    @Override
    public Option<String> getProperty(EngineProperty key) {
        return Option.empty();
    }

    @Override
    public void setJobStatus(String activeModule, String activityDescription) {
    }
}

