/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.state;

import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.FlinkHoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FlinkInMemoryStateIndex<T extends HoodieRecordPayload>
extends FlinkHoodieIndex<T> {
    private static final Logger LOG = LogManager.getLogger(FlinkInMemoryStateIndex.class);
    private MapState<HoodieKey, HoodieRecordLocation> mapState;

    public FlinkInMemoryStateIndex(HoodieFlinkEngineContext context, HoodieWriteConfig config) {
        super(config);
        if (context.getRuntimeContext() != null) {
            MapStateDescriptor indexStateDesc = new MapStateDescriptor("indexState", TypeInformation.of(HoodieKey.class), TypeInformation.of(HoodieRecordLocation.class));
            if (context.getRuntimeContext() != null) {
                this.mapState = context.getRuntimeContext().getMapState(indexStateDesc);
            }
        }
    }

    @Override
    public List<HoodieRecord<T>> tagLocation(List<HoodieRecord<T>> records, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> hoodieTable) throws HoodieIndexException {
        return context.map(records, record -> {
            try {
                if (this.mapState.contains((Object)record.getKey())) {
                    record.unseal();
                    record.setCurrentLocation((HoodieRecordLocation)this.mapState.get((Object)record.getKey()));
                    record.seal();
                }
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Tag record location failed, key = %s, %s", record.getRecordKey(), e.getMessage()));
            }
            return record;
        }, 0);
    }

    @Override
    public List<WriteStatus> updateLocation(List<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> hoodieTable) throws HoodieIndexException {
        return context.map(writeStatuses, writeStatus -> {
            for (HoodieRecord record : writeStatus.getWrittenRecords()) {
                if (writeStatus.isErrored(record.getKey())) continue;
                HoodieKey key = record.getKey();
                Option<HoodieRecordLocation> newLocation = record.getNewLocation();
                if (newLocation.isPresent()) {
                    try {
                        this.mapState.put((Object)key, (Object)newLocation.get());
                    }
                    catch (Exception e) {
                        LOG.error((Object)String.format("Update record location failed, key = %s, %s", record.getRecordKey(), e.getMessage()));
                    }
                    continue;
                }
                try {
                    this.mapState.remove((Object)key);
                }
                catch (Exception e) {
                    LOG.error((Object)String.format("Remove record location failed, key = %s, %s", record.getRecordKey(), e.getMessage()));
                }
            }
            return writeStatus;
        }, 0);
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean canIndexLogFiles() {
        return true;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return false;
    }
}

