/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.clean;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BaseCleanActionExecutor<T extends HoodieRecordPayload, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieCleanMetadata> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger(BaseCleanActionExecutor.class);

    public BaseCleanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime) {
        super(context, config, table, instantTime);
    }

    HoodieCleanerPlan requestClean(HoodieEngineContext context) {
        try {
            CleanPlanner planner = new CleanPlanner(context, this.table, this.config);
            Option<HoodieInstant> earliestInstant = planner.getEarliestCommitToRetain();
            List<String> partitionsToClean = planner.getPartitionPathsToClean(earliestInstant);
            if (partitionsToClean.isEmpty()) {
                LOG.info((Object)"Nothing to clean here.");
                return HoodieCleanerPlan.newBuilder().setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).build();
            }
            LOG.info((Object)("Total Partitions to clean : " + partitionsToClean.size() + ", with policy " + (Object)((Object)this.config.getCleanerPolicy())));
            int cleanerParallelism = Math.min(partitionsToClean.size(), this.config.getCleanerParallelism());
            LOG.info((Object)("Using cleanerParallelism: " + cleanerParallelism));
            context.setJobStatus(this.getClass().getSimpleName(), "Generates list of file slices to be cleaned");
            Map<String, List<HoodieCleanFileInfo>> cleanOps = context.map(partitionsToClean, partitionPathToClean -> Pair.of(partitionPathToClean, planner.getDeletePaths((String)partitionPathToClean)), cleanerParallelism).stream().collect(Collectors.toMap(Pair::getKey, y -> CleanerUtils.convertToHoodieCleanFileInfoList((List)y.getValue())));
            return new HoodieCleanerPlan(earliestInstant.map(x -> new HoodieActionInstant(x.getTimestamp(), x.getAction(), x.getState().name())).orElse(null), this.config.getCleanerPolicy().name(), CollectionUtils.createImmutableMap(new Pair[0]), CleanPlanner.LATEST_CLEAN_PLAN_VERSION, cleanOps);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to schedule clean operation", e);
        }
    }

    protected static Boolean deleteFileAndGetResult(FileSystem fs, String deletePathStr) throws IOException {
        Path deletePath = new Path(deletePathStr);
        LOG.debug((Object)("Working on delete path :" + deletePath));
        try {
            boolean deleteResult = fs.delete(deletePath, false);
            if (deleteResult) {
                LOG.debug((Object)("Cleaned file at path :" + deletePath));
            }
            return deleteResult;
        }
        catch (FileNotFoundException fio) {
            return false;
        }
    }

    abstract List<HoodieCleanStat> clean(HoodieEngineContext var1, HoodieCleanerPlan var2);

    Option<HoodieCleanerPlan> requestClean(String startCleanTime) {
        HoodieCleanerPlan cleanerPlan = this.requestClean(this.context);
        if (cleanerPlan.getFilePathsToBeDeletedPerPartition() != null && !cleanerPlan.getFilePathsToBeDeletedPerPartition().isEmpty() && cleanerPlan.getFilePathsToBeDeletedPerPartition().values().stream().mapToInt(List::size).sum() > 0) {
            HoodieInstant cleanInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", startCleanTime);
            try {
                this.table.getActiveTimeline().saveToCleanRequested(cleanInstant, TimelineMetadataUtils.serializeCleanerPlan(cleanerPlan));
                LOG.info((Object)("Requesting Cleaning with instant time " + cleanInstant));
            }
            catch (IOException e) {
                LOG.error((Object)"Got exception when saving cleaner requested file", (Throwable)e);
                throw new HoodieIOException(e.getMessage(), e);
            }
            return Option.of(cleanerPlan);
        }
        return Option.empty();
    }

    void runPendingClean(HoodieTable<T, I, K, O> table, HoodieInstant cleanInstant) {
        try {
            HoodieCleanerPlan cleanerPlan = CleanerUtils.getCleanerPlan(table.getMetaClient(), cleanInstant);
            this.runClean(table, cleanInstant, cleanerPlan);
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private HoodieCleanMetadata runClean(HoodieTable<T, I, K, O> table, HoodieInstant cleanInstant, HoodieCleanerPlan cleanerPlan) {
        ValidationUtils.checkArgument(cleanInstant.getState().equals((Object)HoodieInstant.State.REQUESTED) || cleanInstant.getState().equals((Object)HoodieInstant.State.INFLIGHT));
        try {
            HoodieTimer timer = new HoodieTimer();
            timer.startTimer();
            HoodieInstant inflightInstant = cleanInstant.isRequested() ? table.getActiveTimeline().transitionCleanRequestedToInflight(cleanInstant, TimelineMetadataUtils.serializeCleanerPlan(cleanerPlan)) : cleanInstant;
            List<HoodieCleanStat> cleanStats = this.clean(this.context, cleanerPlan);
            if (cleanStats.isEmpty()) {
                return HoodieCleanMetadata.newBuilder().build();
            }
            table.getMetaClient().reloadActiveTimeline();
            HoodieCleanMetadata metadata = CleanerUtils.convertCleanMetadata(inflightInstant.getTimestamp(), Option.of(timer.endTimer()), cleanStats);
            table.getActiveTimeline().transitionCleanInflightToComplete(inflightInstant, TimelineMetadataUtils.serializeCleanMetadata(metadata));
            LOG.info((Object)("Marked clean started on " + inflightInstant.getTimestamp() + " as complete"));
            return metadata;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to clean up after commit", e);
        }
    }

    @Override
    public HoodieCleanMetadata execute() {
        Option<HoodieCleanerPlan> cleanerPlanOpt;
        List<HoodieInstant> pendingCleanInstants = this.table.getCleanTimeline().filterInflightsAndRequested().getInstants().collect(Collectors.toList());
        if (pendingCleanInstants.size() > 0) {
            pendingCleanInstants.forEach(hoodieInstant -> {
                LOG.info((Object)("Finishing previously unfinished cleaner instant=" + hoodieInstant));
                try {
                    this.runPendingClean(this.table, (HoodieInstant)hoodieInstant);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to perform previous clean operation, instant: " + hoodieInstant), (Throwable)e);
                }
            });
            this.table.getMetaClient().reloadActiveTimeline();
        }
        if ((cleanerPlanOpt = this.requestClean(this.instantTime)).isPresent()) {
            this.table.getMetaClient().reloadActiveTimeline();
            HoodieCleanerPlan cleanerPlan = cleanerPlanOpt.get();
            if (cleanerPlan.getFilePathsToBeDeletedPerPartition() != null && !cleanerPlan.getFilePathsToBeDeletedPerPartition().isEmpty()) {
                return this.runClean(this.table, HoodieTimeline.getCleanRequestedInstant(this.instantTime), cleanerPlan);
            }
        }
        return null;
    }
}

