/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.utils.MergingIterator;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;

public abstract class AbstractMergeHelper<T extends HoodieRecordPayload, I, K, O> {
    public abstract void runMerge(HoodieTable<T, I, K, O> var1, HoodieMergeHandle<T, I, K, O> var2) throws IOException;

    protected GenericRecord transformRecordBasedOnNewSchema(GenericDatumReader<GenericRecord> gReader, GenericDatumWriter<GenericRecord> gWriter, ThreadLocal<BinaryEncoder> encoderCache, ThreadLocal<BinaryDecoder> decoderCache, GenericRecord gRec) {
        ByteArrayOutputStream inStream = null;
        try {
            GenericRecord transformedRec;
            inStream = new ByteArrayOutputStream();
            BinaryEncoder encoder2 = EncoderFactory.get().binaryEncoder(inStream, encoderCache.get());
            encoderCache.set(encoder2);
            gWriter.write(gRec, encoder2);
            encoder2.flush();
            BinaryDecoder decoder2 = DecoderFactory.get().binaryDecoder(inStream.toByteArray(), decoderCache.get());
            decoderCache.set(decoder2);
            GenericRecord genericRecord = transformedRec = (GenericRecord)gReader.read(null, decoder2);
            return genericRecord;
        }
        catch (IOException e) {
            throw new HoodieException(e);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ioe) {
                throw new HoodieException(ioe.getMessage(), ioe);
            }
        }
    }

    protected Iterator<GenericRecord> getMergingIterator(HoodieTable<T, I, K, O> table, HoodieMergeHandle<T, I, K, O> mergeHandle, HoodieBaseFile baseFile, HoodieFileReader<GenericRecord> reader, Schema readSchema, boolean externalSchemaTransformation) throws IOException {
        Path externalFilePath = new Path(baseFile.getBootstrapBaseFile().get().getPath());
        Configuration bootstrapFileConfig = new Configuration(table.getHadoopConf());
        HoodieFileReader bootstrapReader = HoodieFileReaderFactory.getFileReader(bootstrapFileConfig, externalFilePath);
        Schema bootstrapReadSchema = externalSchemaTransformation ? bootstrapReader.getSchema() : mergeHandle.getWriterSchema();
        return new MergingIterator<GenericRecord>(reader.getRecordIterator(readSchema), bootstrapReader.getRecordIterator(bootstrapReadSchema), inputRecordPair -> HoodieAvroUtils.stitchRecords((GenericRecord)inputRecordPair.getLeft(), (GenericRecord)inputRecordPair.getRight(), mergeHandle.getWriterSchemaWithMetafields()));
    }

    protected static class UpdateHandler
    extends BoundedInMemoryQueueConsumer<GenericRecord, Void> {
        private final HoodieMergeHandle upsertHandle;

        protected UpdateHandler(HoodieMergeHandle upsertHandle) {
            this.upsertHandle = upsertHandle;
        }

        @Override
        protected void consumeOneRecord(GenericRecord record) {
            this.upsertHandle.write(record);
        }

        @Override
        protected void finish() {
        }

        @Override
        protected Void getResult() {
            return null;
        }
    }
}

