/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.action.commit.AbstractWriteHelper;

public class FlinkWriteHelper<T extends HoodieRecordPayload, R>
extends AbstractWriteHelper<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> {
    private FlinkWriteHelper() {
    }

    public static FlinkWriteHelper newInstance() {
        return WriteHelperHolder.FLINK_WRITE_HELPER;
    }

    @Override
    public List<HoodieRecord<T>> deduplicateRecords(List<HoodieRecord<T>> records, HoodieIndex<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> index, int parallelism) {
        boolean isIndexingGlobal = index.isGlobal();
        Map<Object, List<Pair>> keyedRecords = records.stream().map(record -> {
            HoodieKey hoodieKey = record.getKey();
            Object key = isIndexingGlobal ? hoodieKey.getRecordKey() : hoodieKey;
            return Pair.of(key, record);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        return keyedRecords.values().stream().map(x -> x.stream().map(Pair::getRight).reduce((rec1, rec2) -> {
            Object reducedData = rec1.getData().preCombine(rec2.getData());
            HoodieKey reducedKey = rec1.getData().equals(reducedData) ? rec1.getKey() : rec2.getKey();
            return new HoodieRecord(reducedKey, reducedData);
        }).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class WriteHelperHolder {
        private static final FlinkWriteHelper FLINK_WRITE_HELPER = new FlinkWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

