/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.MarkerFiles;
import org.apache.hudi.table.action.rollback.AbstractMarkerBasedRollbackStrategy;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import scala.Tuple2;

public class FlinkMarkerBasedRollbackStrategy<T extends HoodieRecordPayload>
extends AbstractMarkerBasedRollbackStrategy<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    public FlinkMarkerBasedRollbackStrategy(HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        super(table, context, config, instantTime);
    }

    @Override
    public List<HoodieRollbackStat> execute(HoodieInstant instantToRollback) {
        try {
            MarkerFiles markerFiles = new MarkerFiles(this.table, instantToRollback.getTimestamp());
            List<HoodieRollbackStat> rollbackStats = this.context.map(markerFiles.allMarkerFilePaths(), markerFilePath -> {
                String typeStr = markerFilePath.substring(markerFilePath.lastIndexOf(".") + 1);
                IOType type = IOType.valueOf(typeStr);
                switch (type) {
                    case MERGE: {
                        return this.undoMerge(MarkerFiles.stripMarkerSuffix(markerFilePath));
                    }
                    case APPEND: {
                        return this.undoAppend(MarkerFiles.stripMarkerSuffix(markerFilePath), instantToRollback);
                    }
                    case CREATE: {
                        return this.undoCreate(MarkerFiles.stripMarkerSuffix(markerFilePath));
                    }
                }
                throw new HoodieRollbackException("Unknown marker type, during rollback of " + instantToRollback);
            }, 0);
            return rollbackStats.stream().map(rollbackStat -> new Tuple2((Object)rollbackStat.getPartitionPath(), rollbackStat)).collect(Collectors.groupingBy(Tuple2::_1)).values().stream().map(x -> x.stream().map(y -> (HoodieRollbackStat)y._2).reduce(RollbackUtils::mergeRollbackStat).get()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Error rolling back using marker files written for " + instantToRollback, e);
        }
    }
}

