/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.FlinkTaskContextSupplier;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieWriteableTestTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieFlinkWriteableTestTable
extends HoodieWriteableTestTable {
    private static final Logger LOG = LogManager.getLogger(HoodieFlinkWriteableTestTable.class);

    private HoodieFlinkWriteableTestTable(String basePath, FileSystem fs, HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter) {
        super(basePath, fs, metaClient, schema, filter);
    }

    public static HoodieFlinkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter) {
        return new HoodieFlinkWriteableTestTable(metaClient.getBasePath(), metaClient.getRawFs(), metaClient, schema, filter);
    }

    public static HoodieFlinkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema) {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)10000, (double)1.0E-7, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        return HoodieFlinkWriteableTestTable.of(metaClient, schema, filter);
    }

    public static HoodieFlinkWriteableTestTable of(HoodieTable hoodieTable, Schema schema) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        return HoodieFlinkWriteableTestTable.of(metaClient, schema);
    }

    public static HoodieFlinkWriteableTestTable of(HoodieTable hoodieTable, Schema schema, BloomFilter filter) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        return HoodieFlinkWriteableTestTable.of(metaClient, schema, filter);
    }

    public HoodieFlinkWriteableTestTable addCommit(String instantTime) throws Exception {
        return (HoodieFlinkWriteableTestTable)super.addCommit(instantTime);
    }

    public HoodieFlinkWriteableTestTable forCommit(String instantTime) {
        return (HoodieFlinkWriteableTestTable)super.forCommit(instantTime);
    }

    public String getFileIdWithInserts(String partition) throws Exception {
        return this.getFileIdWithInserts(partition, new HoodieRecord[0]);
    }

    public String getFileIdWithInserts(String partition, HoodieRecord ... records) throws Exception {
        return this.getFileIdWithInserts(partition, Arrays.asList(records));
    }

    public String getFileIdWithInserts(String partition, List<HoodieRecord> records) throws Exception {
        String fileId = UUID.randomUUID().toString();
        this.withInserts(partition, fileId, records);
        return fileId;
    }

    public HoodieFlinkWriteableTestTable withInserts(String partition, String fileId) throws Exception {
        return this.withInserts(partition, fileId, new HoodieRecord[0]);
    }

    public HoodieFlinkWriteableTestTable withInserts(String partition, String fileId, HoodieRecord ... records) throws Exception {
        return this.withInserts(partition, fileId, Arrays.asList(records));
    }

    public HoodieFlinkWriteableTestTable withInserts(String partition, String fileId, List<HoodieRecord> records) throws Exception {
        return (HoodieFlinkWriteableTestTable)this.withInserts(partition, fileId, records, (TaskContextSupplier)new FlinkTaskContextSupplier(null));
    }

    public Map<String, List<HoodieLogFile>> withLogAppends(List<HoodieRecord> records) throws Exception {
        HashMap<String, List<HoodieLogFile>> partitionToLogfilesMap = new HashMap<String, List<HoodieLogFile>>();
        for (List<HoodieRecord> groupedRecords : records.stream().collect(Collectors.groupingBy(HoodieRecord::getCurrentLocation)).values()) {
            Pair<String, HoodieLogFile> appendedLogFile = this.appendRecordsToLogFile(groupedRecords);
            partitionToLogfilesMap.computeIfAbsent((String)appendedLogFile.getKey(), k -> new ArrayList()).add(appendedLogFile.getValue());
        }
        return partitionToLogfilesMap;
    }

    private Pair<String, HoodieLogFile> appendRecordsToLogFile(List<HoodieRecord> groupedRecords) throws Exception {
        String partitionPath = groupedRecords.get(0).getPartitionPath();
        HoodieRecordLocation location = groupedRecords.get(0).getCurrentLocation();
        try (HoodieLogFormat.Writer logWriter = HoodieLogFormat.newWriterBuilder().onParentPath(new Path(this.basePath, partitionPath)).withFileExtension(".log").withFileId(location.getFileId()).overBaseCommit(location.getInstantTime()).withFs(this.fs).build();){
            HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
            header.put(HoodieLogBlock.HeaderMetadataType.INSTANT_TIME, location.getInstantTime());
            header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, this.schema.toString());
            logWriter.appendBlock((HoodieLogBlock)new HoodieAvroDataBlock(groupedRecords.stream().map(r -> {
                try {
                    GenericRecord val = (GenericRecord)r.getData().getInsertValue(this.schema).get();
                    HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)val, (String)r.getRecordKey(), (String)r.getPartitionPath(), (String)"");
                    return val;
                }
                catch (IOException e) {
                    LOG.warn((Object)("Failed to convert record " + r.toString()), (Throwable)e);
                    return null;
                }
            }).collect(Collectors.toList()), header));
            Pair pair = Pair.of((Object)partitionPath, (Object)logWriter.getLogFile());
            return pair;
        }
    }
}

