/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieList;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.AbstractDeleteHelper;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;

public class FlinkDeleteHelper<R>
extends AbstractDeleteHelper<EmptyHoodieRecordPayload, List<HoodieRecord<EmptyHoodieRecordPayload>>, List<HoodieKey>, List<WriteStatus>, R> {
    private FlinkDeleteHelper() {
    }

    public static FlinkDeleteHelper newInstance() {
        return DeleteHelperHolder.FLINK_DELETE_HELPER;
    }

    public List<HoodieKey> deduplicateKeys(List<HoodieKey> keys, HoodieTable<EmptyHoodieRecordPayload, List<HoodieRecord<EmptyHoodieRecordPayload>>, List<HoodieKey>, List<WriteStatus>> table, int parallelism) {
        boolean isIndexingGlobal = table.getIndex().isGlobal();
        if (isIndexingGlobal) {
            HashSet recordKeys = keys.stream().map(HoodieKey::getRecordKey).collect(Collectors.toCollection(HashSet::new));
            LinkedList<HoodieKey> deduplicatedKeys = new LinkedList<HoodieKey>();
            keys.forEach(x -> {
                if (recordKeys.contains(x.getRecordKey())) {
                    deduplicatedKeys.add((HoodieKey)x);
                }
            });
            return deduplicatedKeys;
        }
        HashSet<HoodieKey> set = new HashSet<HoodieKey>(keys);
        keys.clear();
        keys.addAll(set);
        return keys;
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute(String instantTime, List<HoodieKey> keys, HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<EmptyHoodieRecordPayload, List<HoodieRecord<EmptyHoodieRecordPayload>>, List<HoodieKey>, List<WriteStatus>> table, BaseCommitActionExecutor<EmptyHoodieRecordPayload, List<HoodieRecord<EmptyHoodieRecordPayload>>, List<HoodieKey>, List<WriteStatus>, R> deleteExecutor) {
        try {
            HoodieWriteMetadata result = null;
            List<HoodieKey> dedupedKeys = keys;
            int parallelism = config.getDeleteShuffleParallelism();
            if (config.shouldCombineBeforeDelete()) {
                dedupedKeys = this.deduplicateKeys(keys, table, parallelism);
            }
            List dedupedRecords = dedupedKeys.stream().map(key -> new HoodieRecord(key, (HoodieRecordPayload)new EmptyHoodieRecordPayload())).collect(Collectors.toList());
            Instant beginTag = Instant.now();
            List taggedRecords = HoodieList.getList((HoodieData)table.getIndex().tagLocation((HoodieData)HoodieList.of(dedupedRecords), context, table));
            Duration tagLocationDuration = Duration.between(beginTag, Instant.now());
            List taggedValidRecords = taggedRecords.stream().filter(HoodieRecord::isCurrentLocationKnown).collect(Collectors.toList());
            if (!taggedValidRecords.isEmpty()) {
                result = deleteExecutor.execute(taggedValidRecords);
                result.setIndexLookupDuration(tagLocationDuration);
            } else {
                deleteExecutor.saveWorkloadProfileMetadataToInflight(new WorkloadProfile(Pair.of(new HashMap(), (Object)new WorkloadStat())), instantTime);
                result = new HoodieWriteMetadata();
                result.setWriteStatuses((Object)Collections.EMPTY_LIST);
                deleteExecutor.commitOnAutoCommit(result);
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw (HoodieUpsertException)e;
            }
            throw new HoodieUpsertException("Failed to delete for commit time " + instantTime, e);
        }
    }

    private static class DeleteHelperHolder {
        private static final FlinkDeleteHelper FLINK_DELETE_HELPER = new FlinkDeleteHelper();

        private DeleteHelperHolder() {
        }
    }
}

