/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.FlinkHoodieIndex;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieFlinkCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;

public abstract class HoodieFlinkTable<T extends HoodieRecordPayload>
extends HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    protected HoodieFlinkTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieFlinkTable<T> create(HoodieWriteConfig config, HoodieFlinkEngineContext context) {
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(context.getHadoopConf().get(), config.getBasePath(), true, config.getConsistencyGuardConfig(), Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion())));
        return HoodieFlinkTable.create(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieFlinkTable<T> create(HoodieWriteConfig config, HoodieFlinkEngineContext context, HoodieTableMetaClient metaClient) {
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                return new HoodieFlinkCopyOnWriteTable(config, context, metaClient);
            }
            case MERGE_ON_READ: {
                throw new HoodieNotSupportedException("MERGE_ON_READ is not supported yet");
            }
        }
        throw new HoodieException("Unsupported table type :" + metaClient.getTableType());
    }

    protected HoodieIndex<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> getIndex(HoodieWriteConfig config, HoodieEngineContext context) {
        return FlinkHoodieIndex.createIndex((HoodieFlinkEngineContext)context, config);
    }
}

